/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.slice;

import java.util.List;
import java.util.stream.Stream;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.match.MatcherIntersectionHelper;
import org.anchoranalysis.plugin.image.bean.object.provider.WithContainerBase;
import org.anchoranalysis.plugin.image.bean.object.provider.slice.ExtendObjectsInZHelper;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class ExtendInZWithinContainer
extends WithContainerBase {
    public ObjectCollection createFromObjects(ObjectCollection objectsSource) throws ProvisionFailedException {
        List<MatchedObject> matchList = MatcherIntersectionHelper.matchIntersectingObjects(this.containerRequired(), objectsSource.duplicate());
        try {
            Stream stream = CheckedStream.flatMap(matchList.stream(), CreateException.class, ExtendInZWithinContainer::extendedMatchedObjects);
            return new ObjectCollection(stream);
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static Stream<ObjectMask> extendedMatchedObjects(MatchedObject matched) throws CreateException {
        ObjectMask source = matched.getSource();
        return CheckedStream.map((Stream)matched.getMatches().streamStandardJava(), CreateException.class, other -> ExtendInZWithinContainer.createExtendedObject(other, source));
    }

    private static ObjectMask createExtendedObject(ObjectMask object, ObjectMask container) throws CreateException {
        ObjectMask flattened = object.flattenZ();
        BoundingBox box = ExtendInZWithinContainer.potentialZExpansion(flattened, container);
        assert (container.boundingBox().contains().box(box));
        return ExtendObjectsInZHelper.createExtendedObject(flattened, container, box, (int)object.centerOfGravity().z());
    }

    private static BoundingBox potentialZExpansion(ObjectMask objectFlattened, ObjectMask container) throws CreateException {
        int zLow = container.boundingBox().cornerMin().z();
        int zHigh = container.boundingBox().calculateCornerMaxInclusive().z();
        Extent extent = objectFlattened.boundingBox().extent().duplicateChangeZ(zHigh - zLow + 1);
        ReadableTuple3i cornerMin = objectFlattened.boundingBox().cornerMin().duplicateChangeZ(zLow);
        return (BoundingBox)BoundingBox.createReuse((ReadableTuple3i)cornerMin, (Extent)extent).intersection().with(container.boundingBox()).orElseThrow(() -> new CreateException("Bounding boxes don't intersect"));
    }
}

