/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.split;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.WithDimensionsBase;
import org.anchoranalysis.spatial.box.Extent;

public class SplitByObjects
extends WithDimensionsBase {
    private static final ObjectsFromConnectedComponentsFactory CONNECTED_COMPONENTS_CREATOR = new ObjectsFromConnectedComponentsFactory();
    @BeanField
    private ObjectCollectionProvider objectsSplitBy;

    public ObjectCollection createFromObjects(ObjectCollection objectCollection) throws ProvisionFailedException {
        ObjectCollection objectsSplitByCollection = (ObjectCollection)this.objectsSplitBy.get();
        Dimensions dimensions = this.createDimensions();
        return objectCollection.stream().flatMap(OperationFailedException.class, object -> this.splitObject((ObjectMask)object, SplitByObjects.findObjectsWithIntersectingBoundingBox(objectsSplitByCollection, object), dimensions.extent()));
    }

    private ObjectCollection splitObject(ObjectMask objectToSplit, ObjectCollection objectsSplitBy, Extent extent) {
        BoundedVoxels voxelsWithIdentifiers = VoxelsFactory.getUnsignedInt().createBounded(objectToSplit.boundingBox());
        int count = 1;
        for (ObjectMask objectLocal : objectsSplitBy) {
            Optional intersect = objectToSplit.intersect(objectLocal, extent);
            if (!intersect.isPresent()) continue;
            voxelsWithIdentifiers.assignValue(count++).toObject((ObjectMask)intersect.get());
        }
        return this.floodFillEachIdentifier(count, (BoundedVoxels<UnsignedIntBuffer>)voxelsWithIdentifiers);
    }

    private ObjectCollection floodFillEachIdentifier(int count, BoundedVoxels<UnsignedIntBuffer> voxelsWithIdentifiers) {
        return ObjectCollectionFactory.flatMapFromRange((int)1, (int)count, index -> SplitByObjects.createObjectForIndex(index, voxelsWithIdentifiers));
    }

    private static ObjectCollection createObjectForIndex(int voxelEqualTo, BoundedVoxels<UnsignedIntBuffer> voxels) {
        BinaryVoxels binaryVoxels = BinaryVoxelsFactory.reuseInt((Voxels)voxels.voxels(), (BinaryValuesInt)new BinaryValuesInt(0, voxelEqualTo));
        return CONNECTED_COMPONENTS_CREATOR.createUnsignedInt(binaryVoxels).shiftBy(voxels.cornerMin());
    }

    private static ObjectCollection findObjectsWithIntersectingBoundingBox(ObjectCollection objects, ObjectMask toIntersectWith) {
        return objects.stream().filter(object -> object.boundingBox().intersection().existsWith(toIntersectWith.boundingBox()));
    }

    @Generated
    public ObjectCollectionProvider getObjectsSplitBy() {
        return this.objectsSplitBy;
    }

    @Generated
    public void setObjectsSplitBy(ObjectCollectionProvider objectsSplitBy) {
        this.objectsSplitBy = objectsSplitBy;
    }
}

