/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.split;

import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProviderUnary;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.split.SquareIterator;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class SplitIntoSquares
extends ObjectCollectionProviderUnary {
    @BeanField
    @Positive
    private int squareSize = 10;
    @BeanField
    private int minNumberVoxels = 1;

    public ObjectCollection createFromObjects(ObjectCollection objectCollection) {
        return objectCollection.stream().flatMap(this::splitObject);
    }

    private ObjectCollection splitObject(ObjectMask object) {
        Extent extent = object.boundingBox().extent();
        SquareIterator iterator = new SquareIterator(extent, this.squareSize, 1, extent.z());
        return ObjectCollectionFactory.mapFromOptional((Iterator)iterator, box -> this.maybeExtractSquare(object, (BoundingBox)box));
    }

    private Optional<ObjectMask> maybeExtractSquare(ObjectMask objectToSplit, BoundingBox box) {
        ObjectMask square = this.extractFromObject(objectToSplit, box);
        if (!square.voxelsOn().higherCountExistsThan(this.minNumberVoxels - 1)) {
            return Optional.empty();
        }
        return Optional.of(square);
    }

    private ObjectMask extractFromObject(ObjectMask objectToSplit, BoundingBox box) {
        Voxels voxelsNew = objectToSplit.voxels().extract().region(box, false);
        return new ObjectMask(box.shiftBy(objectToSplit.boundingBox().cornerMin()), voxelsNew, objectToSplit.binaryValuesByte());
    }

    @Generated
    public int getSquareSize() {
        return this.squareSize;
    }

    @Generated
    public void setSquareSize(int squareSize) {
        this.squareSize = squareSize;
    }

    @Generated
    public int getMinNumberVoxels() {
        return this.minNumberVoxels;
    }

    @Generated
    public void setMinNumberVoxels(int minNumberVoxels) {
        this.minNumberVoxels = minNumberVoxels;
    }
}

