/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.split;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class SquareIterator
implements Iterator<BoundingBox> {
    private final Extent extent;
    private final int squareSize;
    private final int extentZ;
    private final int numberX;
    private final int numberY;
    private Point3i corner;
    private int extentY;

    public SquareIterator(Extent extent, int squareSize, int cornerZ, int extentZ) {
        this.extent = extent;
        this.squareSize = squareSize;
        this.extentZ = extentZ;
        this.numberX = SquareIterator.numberSplitsAlongDimension(extent.x(), squareSize);
        this.numberY = SquareIterator.numberSplitsAlongDimension(extent.y(), squareSize);
        this.corner = new Point3i(0, 0, cornerZ);
        this.moveToY(0);
    }

    @Override
    public boolean hasNext() {
        return this.corner.x() < this.numberX || this.corner.y() < this.numberY;
    }

    @Override
    public BoundingBox next() {
        if (this.corner.x() == this.numberX) {
            this.corner.setX(0);
            this.corner.incrementY();
            if (this.corner.y() == this.numberY) {
                throw new NoSuchElementException();
            }
            this.moveToY(this.corner.y());
        }
        int startX = this.corner.x() * this.squareSize;
        int endX = Math.min(startX + this.squareSize, this.extent.x());
        if (this.corner.x() == this.numberX - 1) {
            endX = Math.min(endX + this.squareSize, this.extent.x());
        }
        Extent squareExtent = new Extent(endX - startX, this.extentY, this.extentZ);
        return BoundingBox.createDuplicate((ReadableTuple3i)this.corner, (Extent)squareExtent);
    }

    private void moveToY(int y) {
        int startY = y * this.squareSize;
        int endY = Math.min(startY + this.squareSize, this.extent.y());
        if (y == this.numberY - 1) {
            endY = Math.min(endY + this.squareSize, this.extent.y());
        }
        this.extentY = endY - startY;
    }

    private static int numberSplitsAlongDimension(int extent, int squareSize) {
        int num = extent / squareSize;
        if (num != 0) {
            return num;
        }
        return 1;
    }
}

