/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedUnaryOperator;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjectsUnary;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.object.scale.Scaler;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class AtScale
extends SegmentChannelIntoObjectsUnary {
    @BeanField
    private ScaleCalculator scaleCalculator;
    @BeanField
    private int outlineWidth = 1;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds, SegmentChannelIntoObjects upstreamSegmenter) throws SegmentationFailedException {
        try {
            ScaleFactor scaleFactor = this.determineScaleFactor(channel.dimensions(), ((ImageInitialization)this.getInitialization()).suggestedSize());
            Extent extent = channel.extent();
            ObjectCollection scaledSegmentationResult = upstreamSegmenter.segment(this.scaleChannel(channel, scaleFactor, this.interpolator.voxelsResizer()), this.scaleMask(objectMask, scaleFactor, extent), this.scaleSeeds(seeds, scaleFactor, extent));
            return this.scaleResultToOriginalScale(scaledSegmentationResult, scaleFactor, channel.dimensions().extent());
        }
        catch (InitializeException | OperationFailedException e) {
            throw new SegmentationFailedException(e);
        }
    }

    private Channel scaleChannel(Channel channel, ScaleFactor scaleFactor, VoxelsResizer resizer) {
        return channel.scaleXY(scaleFactor, resizer);
    }

    private Optional<ObjectMask> scaleMask(Optional<ObjectMask> objectMask, ScaleFactor scaleFactor, Extent extent) throws SegmentationFailedException {
        return AtScale.mapScale(objectMask, object -> object.scale(scaleFactor, Optional.of(extent)), "mask");
    }

    private Optional<ObjectCollection> scaleSeeds(Optional<ObjectCollection> seeds, ScaleFactor scaleFactor, Extent extent) throws SegmentationFailedException {
        return AtScale.mapScale(seeds, seedCollection -> AtScale.scaleSeeds(seedCollection, scaleFactor, extent), "seeds");
    }

    private ScaleFactor determineScaleFactor(Dimensions dimensions, Optional<ImageSizeSuggestion> suggestedSize) throws SegmentationFailedException {
        try {
            return this.scaleCalculator.calculate(Optional.of(dimensions), suggestedSize);
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException("Cannot calculate scale", (Throwable)e);
        }
    }

    private ObjectCollection scaleResultToOriginalScale(ObjectCollection objects, ScaleFactor scaleFactor, Extent originalExtent) throws OperationFailedException {
        return ObjectCollectionFactory.of((Collection[])new Collection[]{Scaler.scaleObjects((ObjectCollection)objects, (ScaleFactor)scaleFactor.invert(), (boolean)true, (Extent)originalExtent).asCollectionOrderNotPreserved()});
    }

    private static <T> Optional<T> mapScale(Optional<T> optional, CheckedUnaryOperator<T, OperationFailedException> scaleFunction, String textualDescriptionInError) throws SegmentationFailedException {
        try {
            if (optional.isPresent()) {
                return Optional.of(scaleFunction.apply(optional.get()));
            }
            return Optional.empty();
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException("Cannot scale " + textualDescriptionInError);
        }
    }

    private static ObjectCollection scaleSeeds(ObjectCollection seedsUnscaled, ScaleFactor scaleFactor, Extent extent) throws OperationFailedException {
        if (scaleFactor.x() != scaleFactor.y()) {
            throw new OperationFailedException("scaleFactor in X and Y must be equal to scale seeds");
        }
        return seedsUnscaled.stream().map(object -> object.scale(scaleFactor, Optional.of(extent)));
    }

    @Generated
    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    @Generated
    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }

    @Generated
    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    @Generated
    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

