/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel;

import lombok.Generated;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ExtendInZHelper {
    public static ObjectCollection extendObjects(ObjectCollection objects2D, BinaryVoxels<UnsignedByteBuffer> mask3D) {
        return objects2D.stream().map(object -> ExtendInZHelper.extendObject(object, mask3D));
    }

    private static ObjectMask extendObject(ObjectMask object2D, BinaryVoxels<UnsignedByteBuffer> voxels3D) {
        return new ObjectMask(ExtendInZHelper.extendObject((BoundedVoxels<UnsignedByteBuffer>)object2D.boundedVoxels(), voxels3D));
    }

    private static BoundedVoxels<UnsignedByteBuffer> extendObject(BoundedVoxels<UnsignedByteBuffer> obj2D, BinaryVoxels<UnsignedByteBuffer> mask3D) {
        BoundingBox newBBox = ExtendInZHelper.createBoundingBoxForAllZ(obj2D.boundingBox(), mask3D.extent().z());
        BoundedVoxels newMask = VoxelsFactory.getUnsignedByte().createBounded(newBBox);
        ReadableTuple3i max = newBBox.calculateCornerMaxInclusive();
        Point3i point = new Point3i();
        BinaryValuesByte binaryValues = mask3D.binaryValues().asByte();
        UnsignedByteBuffer bufferIn2D = (UnsignedByteBuffer)obj2D.voxels().sliceBuffer(0);
        point.setZ(0);
        while (point.z() <= max.z()) {
            UnsignedByteBuffer bufferMask3D = (UnsignedByteBuffer)mask3D.voxels().sliceBuffer(point.z());
            UnsignedByteBuffer bufferOut3D = (UnsignedByteBuffer)newMask.voxels().sliceBuffer(point.z());
            int offset = 0;
            point.setY(newBBox.cornerMin().y());
            while (point.y() <= max.y()) {
                point.setX(newBBox.cornerMin().x());
                while (point.x() <= max.x()) {
                    if (bufferIn2D.getRaw(offset) == binaryValues.getOn()) {
                        int indexGlobal = mask3D.extent().offset(point.x(), point.y());
                        bufferOut3D.putRaw(offset, bufferMask3D.getRaw(indexGlobal) == binaryValues.getOn() ? binaryValues.getOn() : binaryValues.getOff());
                    }
                    point.incrementX();
                    ++offset;
                }
                point.incrementY();
            }
            point.incrementZ();
        }
        return newMask;
    }

    private static BoundingBox createBoundingBoxForAllZ(BoundingBox existing, int z) {
        Point3i cornerMin = ExtendInZHelper.copyPointChangeZ(existing.cornerMin(), 0);
        Extent extent = ExtendInZHelper.copyExtentChangeZ(existing.extent(), z);
        return BoundingBox.createReuse((ReadableTuple3i)cornerMin, (Extent)extent);
    }

    private static Point3i copyPointChangeZ(ReadableTuple3i in, int z) {
        Point3i out = new Point3i(in);
        out.setZ(z);
        return out;
    }

    private static Extent copyExtentChangeZ(Extent in, int z) {
        return new Extent(in.x(), in.y(), z);
    }

    @Generated
    private ExtendInZHelper() {
    }
}

