/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.mser.MserTree;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.ObjectFromPointsFactory;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToImg;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point3i;

public class Mser
extends SegmentChannelIntoObjects {
    @BeanField
    private long minSize = 100L;
    @BeanField
    private long maxSize = 10000000L;
    @BeanField
    private double maxVar = 0.5;
    @BeanField
    private double minDiversity = 0.0;
    @BeanField
    private double delta = 1.0;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds) throws SegmentationFailedException {
        Mser.checkUnsupportedObjectMask(objectMask);
        Mser.checkUnsupportedSeeds(seeds);
        Img img = ConvertToImg.from((VoxelsUntyped)channel.voxels());
        MserTree treeDarkToBright = MserTree.buildMserTree((RandomAccessibleInterval)img, (double)this.delta, (long)this.minSize, (long)this.maxSize, (double)this.maxVar, (double)this.minDiversity, (boolean)true);
        try {
            return this.convertOutputToObjects(treeDarkToBright);
        }
        catch (CreateException exc) {
            throw new SegmentationFailedException((Throwable)exc);
        }
    }

    private <T extends Type<T>> ObjectCollection convertOutputToObjects(MserTree<T> tree) throws CreateException {
        return ObjectCollectionFactory.mapFrom(tree, CreateException.class, mser -> ObjectFromPointsFactory.create(Mser.convertPixelPoints(mser)));
    }

    private static Collection<Point3i> convertPixelPoints(net.imglib2.algorithm.componenttree.mser.Mser<?> mser) {
        LinkedList<Point3i> out = new LinkedList<Point3i>();
        for (Localizable localizable : mser) {
            out.add(new Point3i(localizable.getIntPosition(0), localizable.getIntPosition(1), 0));
        }
        return out;
    }

    @Generated
    public long getMinSize() {
        return this.minSize;
    }

    @Generated
    public void setMinSize(long minSize) {
        this.minSize = minSize;
    }

    @Generated
    public long getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Generated
    public double getMaxVar() {
        return this.maxVar;
    }

    @Generated
    public void setMaxVar(double maxVar) {
        this.maxVar = maxVar;
    }

    @Generated
    public double getMinDiversity() {
        return this.minDiversity;
    }

    @Generated
    public void setMinDiversity(double minDiversity) {
        this.minDiversity = minDiversity;
    }

    @Generated
    public double getDelta() {
        return this.delta;
    }

    @Generated
    public void setDelta(double delta) {
        this.delta = delta;
    }
}

