/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjectsUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.ExtendInZHelper;

public class SegmentOnMaximumIntensityAndExpandInZ
extends SegmentChannelIntoObjectsUnary {
    @BeanField
    private BinarySegmentation segmentStack;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds, SegmentChannelIntoObjects upstreamSegmenter) throws SegmentationFailedException {
        if (objectMask.isPresent()) {
            throw new SegmentationFailedException("An object-mask is not supported for this operation");
        }
        seeds.ifPresent(SegmentOnMaximumIntensityAndExpandInZ::flattenSeedsInZ);
        ObjectCollection objects = upstreamSegmenter.segment(channel.projectMax(), Optional.empty(), seeds);
        if (this.isAny3d(objects)) {
            throw new SegmentationFailedException("A 3D object was returned from the initial segmentation. This must return only 2D objects");
        }
        return ExtendInZHelper.extendObjects(objects, this.binarySgmn(channel));
    }

    private boolean isAny3d(ObjectCollection objects) {
        return objects.stream().anyMatch(objectMask -> objectMask.extent().z() > 1);
    }

    private BinaryVoxels<UnsignedByteBuffer> binarySgmn(Channel channel) throws SegmentationFailedException {
        BinarySegmentationParameters parameters = new BinarySegmentationParameters(channel.resolution());
        Voxels voxels = channel.voxels().asByte();
        Voxels stackBinary = voxels.duplicate();
        return this.segmentStack.segment(new VoxelsUntyped(stackBinary), parameters, Optional.empty());
    }

    private static ObjectCollection flattenSeedsInZ(ObjectCollection seeds) {
        return seeds.stream().map(ObjectMask::flattenZ);
    }

    @Generated
    public BinarySegmentation getSegmentStack() {
        return this.segmentStack;
    }

    @Generated
    public void setSegmentStack(BinarySegmentation segmentStack) {
        this.segmentStack = segmentStack;
    }
}

