/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.spatial.box.PointRange;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class BoundingBoxMap {
    private List<PointRange> list = new ArrayList<PointRange>();
    private HashMap<Integer, Integer> map = new HashMap();

    BoundingBoxMap() {
    }

    public int indexForValue(int val) {
        return this.map.computeIfAbsent(val, key -> {
            int idNew = this.list.size();
            this.list.add(null);
            return idNew;
        });
    }

    public ObjectCollection deriveObjects(Voxels<UnsignedIntBuffer> matS) throws OperationFailedException {
        return ObjectCollectionFactory.filterAndMapWithIndexFrom(this.list, Objects::nonNull, OperationFailedException.class, (pointRange, index) -> matS.extract().voxelsEqualTo(index + 1).deriveObject(pointRange.toBoundingBox()));
    }

    public int addPointForValue(Point3i point, int val) {
        int reorderedIndex = this.indexForValue(val);
        this.addPointToBox(reorderedIndex, point);
        return reorderedIndex;
    }

    private void addPointToBox(int indx, Point3i point) {
        PointRange pointRange = this.list.get(indx);
        if (pointRange == null) {
            pointRange = new PointRange();
            this.list.set(indx, pointRange);
        }
        pointRange.add((ReadableTuple3i)point);
    }
}

