/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.IterateVoxelsNeighbors;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsoluteWithSlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborFactory;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;
import org.anchoranalysis.image.voxel.neighborhood.NeighborhoodFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.EqualVoxelsPlateau;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedIntBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class FindEqualVoxels {
    private final Voxels<?> bufferValuesToFindEqual;
    private final EncodedVoxels matS;
    private final boolean do3D;
    private final Optional<ObjectMask> objectMask;

    public EqualVoxelsPlateau createPlateau(Point3i point) {
        EqualVoxelsPlateau plateau = new EqualVoxelsPlateau();
        SlidingBuffer slidingBuffer = new SlidingBuffer(this.bufferValuesToFindEqual);
        LinkedList<Point3i> stack = new LinkedList<Point3i>();
        stack.push(point);
        this.processStack(stack, slidingBuffer, plateau, this.valueToFind(point));
        assert (!plateau.hasNullItems());
        return plateau;
    }

    private int valueToFind(Point3i point) {
        return this.bufferValuesToFindEqual.extract().voxel((ReadableTuple3i)point);
    }

    private void processStack(Deque<Point3i> stack, SlidingBuffer<?> slidingBuffer, EqualVoxelsPlateau plateau, int valToFind) {
        ProcessVoxelNeighbor process = ProcessVoxelNeighborFactory.within(this.objectMask, (Extent)slidingBuffer.extent(), (ProcessVoxelNeighborAbsolute)new PointEvaluator(stack, slidingBuffer, this.matS));
        Neighborhood neighborhood = NeighborhoodFactory.of((boolean)true);
        while (!stack.isEmpty()) {
            int offset;
            Point3i point = stack.pop();
            EncodedIntBuffer bufferVisited = this.matS.getPixelsForPlane(point.z());
            if (bufferVisited.isTemporary(offset = slidingBuffer.extent().offsetSlice((ReadableTuple3i)point))) continue;
            slidingBuffer.seek(point.z());
            Optional lowestNeighborIndex = (Optional)IterateVoxelsNeighbors.callEachPointInNeighborhood((Point3i)point, (Neighborhood)neighborhood, (boolean)this.do3D, (ProcessVoxelNeighbor)process, (int)valToFind, (int)offset);
            bufferVisited.markAsTemporary(offset);
            if (lowestNeighborIndex.isPresent()) {
                plateau.addEdge(point, (Integer)lowestNeighborIndex.get());
                continue;
            }
            plateau.addInner(point);
        }
    }

    public boolean isDo3D() {
        return this.do3D;
    }

    @Generated
    public FindEqualVoxels(Voxels<?> bufferValuesToFindEqual, EncodedVoxels matS, boolean do3D, Optional<ObjectMask> objectMask) {
        this.bufferValuesToFindEqual = bufferValuesToFindEqual;
        this.matS = matS;
        this.do3D = do3D;
        this.objectMask = objectMask;
    }

    private static class PointEvaluator
    extends ProcessVoxelNeighborAbsoluteWithSlidingBuffer<Optional<Integer>> {
        private Deque<Point3i> stack;
        private EncodedVoxels matS;
        private int lowestNeighborVal;
        private int lowestNeighborIndex = -1;
        private EncodedIntBuffer bufS;
        private int z1;

        public PointEvaluator(Deque<Point3i> stack, SlidingBuffer<?> buffer, EncodedVoxels matS) {
            super(buffer);
            this.stack = stack;
            this.matS = matS;
        }

        public void initSource(int sourceValue, int sourceOffsetXY) {
            super.initSource(sourceValue, sourceOffsetXY);
            this.lowestNeighborVal = sourceValue;
            this.lowestNeighborIndex = -1;
        }

        public Optional<Integer> collectResult() {
            if (this.lowestNeighborIndex != -1) {
                return Optional.of(this.lowestNeighborIndex);
            }
            return Optional.empty();
        }

        public void notifyChangeZ(int zChange, int z1) {
            super.notifyChangeZ(zChange, z1);
            this.bufS = this.matS.getPixelsForPlane(z1);
            this.z1 = z1;
        }

        public void processPoint(int xChange, int yChange, int x1, int y1) {
            int offset = this.changedOffset(xChange, yChange);
            int valPoint = this.getInt(offset);
            if (this.bufS.isConnectedComponentID(offset)) {
                if (this.lowestNeighborIndex == -1) {
                    this.lowestNeighborVal = valPoint;
                    this.lowestNeighborIndex = EncodedVoxels.ENCODING.encodeDirection(xChange, yChange, this.zChange);
                } else if (valPoint < this.lowestNeighborVal) {
                    this.lowestNeighborVal = valPoint;
                    this.lowestNeighborIndex = EncodedVoxels.ENCODING.encodeDirection(xChange, yChange, this.zChange);
                }
            }
            if (valPoint == this.sourceValue) {
                this.stack.push(new Point3i(x1, y1, this.z1));
            } else if (valPoint < this.sourceValue && valPoint < this.lowestNeighborVal) {
                this.lowestNeighborVal = valPoint;
                this.lowestNeighborIndex = EncodedVoxels.ENCODING.encodeDirection(xChange, yChange, this.zChange);
            }
        }
    }
}

