/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.ConnectedComponentWriter;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MinimaStore;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;

class MarkSeeds {
    public static void apply(ObjectCollection seeds, EncodedVoxels matS, Optional<MinimaStore> minimaStore, Optional<ObjectMask> containingMask) throws SegmentationFailedException {
        if (containingMask.isPresent() && !matS.extent().equals((Object)containingMask.get().boundingBox().extent())) {
            throw new SegmentationFailedException("Extent of matS does not match containingMask");
        }
        for (ObjectMask object : seeds) {
            MarkSeeds.throwExceptionIfNotConnected(object);
            IterateVoxelsObjectMask.withPoint((ObjectMask)object, containingMask, (ProcessPoint)MarkSeeds.createPointProcessor(matS, minimaStore));
        }
    }

    private static ProcessPoint createPointProcessor(EncodedVoxels matS, Optional<MinimaStore> minimaStore) {
        ConnectedComponentWriter ccWriter = new ConnectedComponentWriter(matS, minimaStore);
        return ccWriter::writePoint;
    }

    private static void throwExceptionIfNotConnected(ObjectMask obj) throws SegmentationFailedException {
        if (!obj.checkIfConnected()) {
            throw new SegmentationFailedException("Seed must be a single connected-component");
        }
    }

    @Generated
    private MarkSeeds() {
    }
}

