/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMaskOptional;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.BoundingBoxMap;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.ConvertAllToConnectedComponents;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MarkSeeds;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.MinimaStore;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.PointPixelsOrMarkAsMinima;
import org.anchoranalysis.plugin.image.bean.object.segment.channel.watershed.yeong.SlidingBufferPlus;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;
import org.anchoranalysis.spatial.box.Extent;

public class WatershedYeong
extends SegmentChannelIntoObjects {
    @BeanField
    private boolean exitWithMinima = false;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds) throws SegmentationFailedException {
        EncodedVoxels matS = this.createS(channel.extent());
        Optional minimaStore = OptionalFactory.create((boolean)this.exitWithMinima, MinimaStore::new);
        if (seeds.isPresent()) {
            MarkSeeds.apply(seeds.get(), matS, minimaStore, objectMask);
        }
        WatershedYeong.pointPixelsOrMarkAsMinima(channel.voxels().any(), matS, objectMask, minimaStore);
        if (minimaStore.isPresent()) {
            try {
                return ((MinimaStore)minimaStore.get()).createObjects();
            }
            catch (CreateException e) {
                throw new SegmentationFailedException((Throwable)e);
            }
        }
        WatershedYeong.convertAllToConnectedComponents(matS, objectMask);
        try {
            return WatershedYeong.createObjectsFromLabels(matS.voxels(), objectMask);
        }
        catch (CreateException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
    }

    private EncodedVoxels createS(Extent extent) {
        return new EncodedVoxels((Voxels<UnsignedIntBuffer>)VoxelsFactory.getUnsignedInt().createInitialized(extent));
    }

    private static void pointPixelsOrMarkAsMinima(Voxels<?> voxelsImg, EncodedVoxels matS, Optional<ObjectMask> objectMask, Optional<MinimaStore> minimaStore) {
        SlidingBufferPlus buffer = new SlidingBufferPlus(voxelsImg, matS, objectMask, minimaStore);
        IterateVoxelsObjectMaskOptional.withSlidingBuffer(objectMask, buffer.getSlidingBuffer(), (ProcessPoint)new PointPixelsOrMarkAsMinima(buffer));
    }

    private static void convertAllToConnectedComponents(EncodedVoxels matS, Optional<ObjectMask> objectMask) {
        IterateVoxelsObjectMaskOptional.withBuffer(objectMask, matS.voxels(), (ProcessBufferUnary)new ConvertAllToConnectedComponents(matS));
    }

    private static ObjectCollection createObjectsFromLabels(Voxels<UnsignedIntBuffer> matS, Optional<ObjectMask> objectMask) throws CreateException {
        BoundingBoxMap bbm = new BoundingBoxMap();
        IterateVoxelsObjectMaskOptional.withBuffer(objectMask, matS, (point, buffer, offset) -> {
            int value = buffer.getRaw(offset);
            buffer.putRaw(offset, bbm.addPointForValue(point, value) + 1);
        });
        try {
            return bbm.deriveObjects(matS);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    @Generated
    public boolean isExitWithMinima() {
        return this.exitWithMinima;
    }

    @Generated
    public void setExitWithMinima(boolean exitWithMinima) {
        this.exitWithMinima = exitWithMinima;
    }
}

