/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.reduce;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class DeriveObjectsFromMask {
    public static List<WithConfidence<ObjectMask>> splitIntoObjects(Mask mask, Channel channel, DoubleUnaryOperator transformToConfidence, ReadableTuple3i shift, int minNumberVoxels) throws OperationFailedException {
        Preconditions.checkArgument((boolean)mask.extent().equals((Object)channel.extent()));
        ObjectsFromConnectedComponentsFactory creator = new ObjectsFromConnectedComponentsFactory(minNumberVoxels);
        ObjectCollection objects = creator.createUnsignedByte(mask.binaryVoxels());
        return objects.stream().mapToList(object -> DeriveObjectsFromMask.deriveConfidenceAndShift(object, channel, transformToConfidence, shift));
    }

    private static WithConfidence<ObjectMask> deriveConfidenceAndShift(ObjectMask object, Channel channel, DoubleUnaryOperator transformToConfidence, ReadableTuple3i shift) throws OperationFailedException {
        return new WithConfidence((Object)object.shiftBy(shift), DeriveObjectsFromMask.confidenceForObject(object, channel, transformToConfidence));
    }

    private static double confidenceForObject(ObjectMask object, Channel channel, DoubleUnaryOperator unscale) throws OperationFailedException {
        Histogram histogram = HistogramFromObjectsFactory.createFrom((Channel)channel, (ObjectMask)object);
        return unscale.applyAsDouble(histogram.mean());
    }

    @Generated
    private DeriveObjectsFromMask() {
    }
}

