/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.scale;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class FitTo
extends ScaleCalculator {
    @BeanField
    private SizeXY targetSize;
    @BeanField
    private boolean preserveAspectRatio = true;
    @BeanField
    private int multipleOf = 1;

    public ScaleFactor calculate(Optional<Dimensions> dimensionsToBeScaled, Optional<ImageSizeSuggestion> suggestedSize) throws OperationFailedException {
        if (!dimensionsToBeScaled.isPresent()) {
            throw new OperationFailedException("dimensionsToBeScaled is required by the plugin but is missing.");
        }
        Extent originalSize = dimensionsToBeScaled.get().extent();
        Extent resized = this.calculateResized(originalSize);
        if (this.multipleOf != 1) {
            resized = FitTo.roundExtentToNearestMultiple(resized, this.multipleOf);
        }
        return RelativeScaleCalculator.relativeScale((Extent)originalSize, (Extent)resized);
    }

    private Extent calculateResized(Extent originalSize) {
        Extent target = this.targetSize.asExtent();
        if (this.preserveAspectRatio) {
            ScaleFactor scaleFactor = RelativeScaleCalculator.relativeScalePreserveAspectRatio((Extent)originalSize, (Extent)target);
            return originalSize.scaleXYBy(scaleFactor, true);
        }
        return target;
    }

    private static Extent roundExtentToNearestMultiple(Extent extent, int multipleOf) {
        return new Extent(FitTo.roundToNearestMultiple(extent.x(), multipleOf), FitTo.roundToNearestMultiple(extent.y(), multipleOf), extent.z());
    }

    private static int roundToNearestMultiple(int valueToRound, int multipleOf) {
        double valueAsDouble = valueToRound;
        return (int)Math.round(valueAsDouble / (double)multipleOf) * multipleOf;
    }

    @Generated
    public SizeXY getTargetSize() {
        return this.targetSize;
    }

    @Generated
    public void setTargetSize(SizeXY targetSize) {
        this.targetSize = targetSize;
    }

    @Generated
    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @Generated
    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    @Generated
    public int getMultipleOf() {
        return this.multipleOf;
    }

    @Generated
    public void setMultipleOf(int multipleOf) {
        this.multipleOf = multipleOf;
    }
}

