/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.scale;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class MinimumXYResolution
extends ScaleCalculator {
    @BeanField
    private double minResolution = 1.0E-8;

    public ScaleFactor calculate(Optional<Dimensions> dimensionsToBeScaled, Optional<ImageSizeSuggestion> suggestedSize) throws OperationFailedException {
        Resolution resolution = (Resolution)dimensionsToBeScaled.flatMap(Dimensions::resolution).orElseThrow(() -> new OperationFailedException("No source resolution exists"));
        if (resolution.x() == 0.0 || resolution.y() == 0.0) {
            throw new OperationFailedException("Channel has zero x or y resolution. Cannot scale to min res.");
        }
        int x = MinimumXYResolution.ratio(resolution.x(), this.minResolution);
        int y = MinimumXYResolution.ratio(resolution.y(), this.minResolution);
        if (x < 0) {
            throw new OperationFailedException(String.format("Insufficient resolution (%E). %E is required", resolution.x(), this.minResolution));
        }
        if (y < 0) {
            throw new OperationFailedException(String.format("Insufficient resolution (%E). %E is required", resolution.y(), this.minResolution));
        }
        double xScaleDownRatio = MinimumXYResolution.twoToMinusPower(x);
        double yScaleDownRatio = MinimumXYResolution.twoToMinusPower(y);
        this.getLogger().messageLogger().logFormatted("Downscaling by factor %d,%d (mult by %f,%f)", new Object[]{x, y, xScaleDownRatio, yScaleDownRatio});
        return new ScaleFactor(xScaleDownRatio, yScaleDownRatio);
    }

    private static int ratio(double currentResolution, double minimumResolution) {
        double ratio = minimumResolution / currentResolution;
        double ratioLog2 = Math.log10(ratio) / Math.log10(2.0);
        if (ratioLog2 > 0.0) {
            return (int)Math.floor(ratioLog2);
        }
        return (int)Math.ceil(ratioLog2);
    }

    private static double twoToMinusPower(int power) {
        return Math.pow(2.0, -1.0 * (double)power);
    }

    @Generated
    public double getMinResolution() {
        return this.minResolution;
    }

    @Generated
    public void setMinResolution(double minResolution) {
        this.minResolution = minResolution;
    }
}

