/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.scale;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.plugin.image.bean.dimensions.provider.SpecifyDimensions;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ToDimensions
extends ScaleCalculator {
    @BeanField
    private DimensionsProvider dimensions;
    @BeanField
    @OptionalBean
    private DimensionsProvider dimensionsSourceFallback;
    @BeanField
    private boolean preserveAspectRatio = false;

    public ToDimensions(int sizeX, int sizeY) {
        this(new SpecifyDimensions(sizeX, sizeY));
    }

    public ToDimensions(DimensionsProvider dimensions) {
        this(dimensions, false);
    }

    public ToDimensions(int sizeX, int sizeY, boolean preserveAspectRatio) {
        this(sizeX, sizeY);
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public ToDimensions(DimensionsProvider dimensions, boolean preserveAspectRatio) {
        this.dimensions = dimensions;
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public ScaleFactor calculate(Optional<Dimensions> dimensionsToBeScaled, Optional<ImageSizeSuggestion> suggestedSize) throws OperationFailedException {
        Optional<Dimensions> dimensionsCombined = this.maybeReplaceSourceDimensions(dimensionsToBeScaled);
        if (dimensionsCombined.isPresent()) {
            try {
                return RelativeScaleCalculator.relativeScale((Extent)dimensionsCombined.get().extent(), (Extent)((Dimensions)this.dimensions.get()).extent(), (boolean)this.preserveAspectRatio);
            }
            catch (ProvisionFailedException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        throw new OperationFailedException("No source dimensions can be found");
    }

    private Optional<Dimensions> maybeReplaceSourceDimensions(Optional<Dimensions> sourceDimensions) throws OperationFailedException {
        if (this.dimensionsSourceFallback != null) {
            try {
                return Optional.of((Dimensions)this.dimensionsSourceFallback.get());
            }
            catch (ProvisionFailedException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return sourceDimensions;
    }

    @Generated
    public ToDimensions() {
    }

    @Generated
    public DimensionsProvider getDimensions() {
        return this.dimensions;
    }

    @Generated
    public void setDimensions(DimensionsProvider dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public DimensionsProvider getDimensionsSourceFallback() {
        return this.dimensionsSourceFallback;
    }

    @Generated
    public void setDimensionsSourceFallback(DimensionsProvider dimensionsSourceFallback) {
        this.dimensionsSourceFallback = dimensionsSourceFallback;
    }

    @Generated
    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @Generated
    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }
}

