/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.segment.binary;

import java.util.Optional;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentationUnary;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class Invert
extends BinarySegmentationUnary {
    public BinaryVoxels<UnsignedByteBuffer> segmentFromExistingSegmentation(VoxelsUntyped voxels, BinarySegmentationParameters parameters, Optional<ObjectMask> objectMask, BinarySegmentation segment) throws SegmentationFailedException {
        BinaryVoxels voxelsSegmented = segment.segment(voxels, parameters, objectMask);
        this.invertVoxels((BinaryVoxels<UnsignedByteBuffer>)voxelsSegmented);
        return voxelsSegmented;
    }

    private void invertVoxels(BinaryVoxels<UnsignedByteBuffer> voxels) {
        BinaryValuesByte bv = voxels.binaryValues().asByte();
        int volumeXY = voxels.extent().areaXY();
        for (int z = 0; z < voxels.extent().z(); ++z) {
            UnsignedByteBuffer buffer = (UnsignedByteBuffer)voxels.sliceBuffer(z);
            for (int index = 0; index < volumeXY; ++index) {
                byte val = buffer.getRaw(index);
                if (val == bv.getOn()) {
                    buffer.putRaw(index, bv.getOff());
                    continue;
                }
                if (val == bv.getOff()) {
                    buffer.putRaw(index, bv.getOn());
                    continue;
                }
                assert (false);
            }
        }
    }
}

