/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.segment.binary;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentationUnary;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class Repeat
extends BinarySegmentationUnary {
    @BeanField
    @Positive
    private int iterations = 10;

    public BinaryVoxels<UnsignedByteBuffer> segmentFromExistingSegmentation(VoxelsUntyped voxels, BinarySegmentationParameters parameters, Optional<ObjectMask> objectMask, BinarySegmentation segment) throws SegmentationFailedException {
        BinaryVoxels outOld = null;
        int count = 0;
        while (count++ < this.iterations) {
            BinaryVoxels outNew = segment.segment(voxels, parameters, objectMask);
            if (outNew == null) {
                return outOld;
            }
            outOld = outNew;
            objectMask = Optional.of(objectMask.isPresent() ? new ObjectMask(objectMask.get().boundingBox(), outNew) : new ObjectMask(outNew));
        }
        return outOld;
    }

    @Generated
    public int getIterations() {
        return this.iterations;
    }

    @Generated
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }
}

