/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.stack.provider;

import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.stack.Stack;

public class FromChannelOrMask
extends StackProvider {
    @BeanField
    @OptionalBean
    private ChannelProvider channel;
    @BeanField
    @OptionalBean
    private Provider<Mask> mask;
    @BeanField
    private boolean rgb = false;

    public FromChannelOrMask(ChannelProvider channel) {
        this.channel = channel;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (!(this.channel != null ^ this.mask != null)) {
            throw new BeanMisconfiguredException("Either channel or mask must be set");
        }
    }

    public Stack get() throws ProvisionFailedException {
        return this.createStackFromChannel(this.channelFromSource());
    }

    private Stack createStackFromChannel(Channel channel) {
        if (this.rgb) {
            try {
                return new Stack(true, new Channel[]{channel, channel.duplicate(), channel.duplicate()});
            }
            catch (CreateException | IncorrectImageSizeException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
        return new Stack(channel);
    }

    private Channel channelFromSource() throws ProvisionFailedException {
        if (this.channel != null) {
            return (Channel)this.channel.get();
        }
        return ((Mask)this.mask.get()).channel();
    }

    @Generated
    public FromChannelOrMask() {
    }

    @Generated
    public ChannelProvider getChannel() {
        return this.channel;
    }

    @Generated
    public void setChannel(ChannelProvider channel) {
        this.channel = channel;
    }

    @Generated
    public Provider<Mask> getMask() {
        return this.mask;
    }

    @Generated
    public void setMask(Provider<Mask> mask) {
        this.mask = mask;
    }

    @Generated
    public boolean isRgb() {
        return this.rgb;
    }

    @Generated
    public void setRgb(boolean rgb) {
        this.rgb = rgb;
    }
}

