/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.stack.provider;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.AnchorCheckedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.Stack;

public class Reference
extends StackProvider {
    @BeanField
    private String id = "";
    private Stack stack;

    public Reference(String id) {
        this.id = id;
    }

    public Stack get() throws ProvisionFailedException {
        if (this.stack == null) {
            this.stack = this.findMatchingStack().orElseThrow(() -> new ProvisionFailedException("Cannot find a stack with id: " + this.id));
        }
        return this.stack;
    }

    private Optional<Stack> findMatchingStack() throws ProvisionFailedException {
        try {
            return OptionalUtilities.orElseGetFlat((Optional)OptionalUtilities.orElseGetFlat(this.fromStacks(), (CheckedSupplier[])new CheckedSupplier[]{this::fromChannels}), (CheckedSupplier[])new CheckedSupplier[]{this::fromMasks});
        }
        catch (AnchorCheckedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Optional<Stack> fromStacks() throws NamedProviderGetException, InitializeException {
        return ((ImageInitialization)this.getInitialization()).stacks().getOptional(this.id);
    }

    private Optional<Stack> fromChannels() throws NamedProviderGetException, InitializeException {
        return ((ImageInitialization)this.getInitialization()).channels().getOptional(this.id).map(Stack::new);
    }

    private Optional<Stack> fromMasks() throws NamedProviderGetException, InitializeException {
        return ((ImageInitialization)this.getInitialization()).masks().getOptional(this.id).map(mask -> new Stack(mask.channel()));
    }

    @Generated
    public Reference() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

