/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.stack.provider.color;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.shared.color.scheme.ColorScheme;
import org.anchoranalysis.bean.shared.color.scheme.HSB;
import org.anchoranalysis.bean.shared.color.scheme.Shuffle;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.ProviderAsStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.object.draw.Filled;
import org.anchoranalysis.image.io.bean.object.draw.Outline;
import org.anchoranalysis.image.io.object.output.rgb.DrawObjectsGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.plugin.image.object.ColoredObjectCollection;

public abstract class ColoredBase
extends StackProvider {
    protected static final ColorScheme DEFAULT_COLOR_SET_GENERATOR = new Shuffle((ColorScheme)new HSB());
    @BeanField
    private boolean flatten = false;
    @BeanField
    private boolean outline = true;
    @BeanField
    @Positive
    private int outlineWidth = 1;
    @BeanField
    private boolean suppressOutlineZ = true;
    @BeanField
    private ProviderAsStack background;
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;

    public Stack get() throws ProvisionFailedException {
        try {
            DisplayStack unflattened = this.createUnflattenedBackground();
            return this.drawOnBackground(this.coloredObjectsToDraw(unflattened.dimensions()), unflattened);
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    protected abstract ColoredObjectCollection coloredObjectsToDraw(Dimensions var1) throws CreateException;

    private Stack drawOnBackground(ColoredObjectCollection objects, DisplayStack background) throws CreateException {
        return this.drawOnBackgroundAfterFlattening(this.maybeFlatten(objects), this.maybeFlatten(background));
    }

    private DrawObject createDrawer() {
        if (this.outline) {
            return new Outline(this.getOutlineWidth(), !this.flatten && !this.suppressOutlineZ);
        }
        return new Filled();
    }

    private DisplayStack createUnflattenedBackground() throws CreateException {
        try {
            return this.displayer.deriveFrom(this.background.getAsStack());
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private Stack drawOnBackgroundAfterFlattening(ColoredObjectCollection objects, DisplayStack background) throws CreateException {
        try {
            DrawObjectsGenerator generator = DrawObjectsGenerator.withBackgroundAndColors((DrawObject)this.createDrawer(), (DisplayStack)background, (ColorIndex)objects.deriveColorList());
            ObjectCollectionWithProperties objectsToTransform = new ObjectCollectionWithProperties(objects.streamObjectWithProperties());
            return generator.transform(objectsToTransform);
        }
        catch (OutputWriteFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private DisplayStack maybeFlatten(DisplayStack stack) {
        if (this.flatten) {
            return stack.projectMax();
        }
        return stack;
    }

    private ColoredObjectCollection maybeFlatten(ColoredObjectCollection objects) {
        if (this.flatten) {
            return objects.flattenZ();
        }
        return objects;
    }

    @Generated
    public boolean isFlatten() {
        return this.flatten;
    }

    @Generated
    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    @Generated
    public boolean isOutline() {
        return this.outline;
    }

    @Generated
    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    @Generated
    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    @Generated
    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    @Generated
    public boolean isSuppressOutlineZ() {
        return this.suppressOutlineZ;
    }

    @Generated
    public void setSuppressOutlineZ(boolean suppressOutlineZ) {
        this.suppressOutlineZ = suppressOutlineZ;
    }

    @Generated
    public ProviderAsStack getBackground() {
        return this.background;
    }

    @Generated
    public void setBackground(ProviderAsStack background) {
        this.background = background;
    }

    @Generated
    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    @Generated
    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

