/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.stack.provider.color;

import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class ThreeChannels
extends StackProvider {
    @BeanField
    @OptionalBean
    private ChannelProvider red;
    @BeanField
    @OptionalBean
    private ChannelProvider green;
    @BeanField
    @OptionalBean
    private ChannelProvider blue;

    private static Dimensions combineWithExisting(Dimensions existing, Channel toCombine) throws IncorrectImageSizeException {
        if (toCombine == null) {
            return existing;
        }
        if (existing == null) {
            return toCombine.dimensions();
        }
        if (!existing.equals((Object)toCombine.dimensions())) {
            throw new IncorrectImageSizeException("dims are not equal");
        }
        return existing;
    }

    private static Dimensions createDimensions(Channel channelRed, Channel channelGreen, Channel channelBlue) throws IncorrectImageSizeException {
        if (channelRed == null && channelGreen == null && channelBlue == null) {
            throw new IllegalArgumentException("All channels are null");
        }
        Dimensions dimensions = null;
        dimensions = ThreeChannels.combineWithExisting(dimensions, channelRed);
        dimensions = ThreeChannels.combineWithExisting(dimensions, channelGreen);
        dimensions = ThreeChannels.combineWithExisting(dimensions, channelBlue);
        return dimensions;
    }

    private static void addToStack(Stack stack, Channel channel, Dimensions dimensions, VoxelDataType outputChannelType) throws IncorrectImageSizeException, ProvisionFailedException {
        if (channel == null) {
            channel = ChannelFactory.instance().create(dimensions, outputChannelType);
        }
        if (!outputChannelType.equals((Object)channel.getVoxelDataType())) {
            throw new ProvisionFailedException(String.format("Channel has a different type (%s) that the expected output-type (%s)", channel.getVoxelDataType(), outputChannelType));
        }
        stack.addChannel(channel);
    }

    private static String voxelDataTypeString(Channel channel) {
        if (channel != null) {
            return channel.getVoxelDataType().toString();
        }
        return "empty";
    }

    private static VoxelDataType chooseOutputDataType(Channel channelRed, Channel channelGreen, Channel channelBlue) throws ProvisionFailedException {
        Channel[] all;
        UnsignedByteVoxelType dataType = null;
        for (Channel c : all = new Channel[]{channelRed, channelGreen, channelBlue}) {
            if (c == null) continue;
            if (dataType == null) {
                dataType = c.getVoxelDataType();
                continue;
            }
            if (c.getVoxelDataType().equals((Object)dataType)) continue;
            String s = String.format("Input channels have different voxel data types. Red=%s; Green=%s; Blue=%s", ThreeChannels.voxelDataTypeString(channelRed), ThreeChannels.voxelDataTypeString(channelGreen), ThreeChannels.voxelDataTypeString(channelBlue));
            throw new ProvisionFailedException(s);
        }
        if (dataType == null) {
            dataType = UnsignedByteVoxelType.INSTANCE;
        }
        return dataType;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.red == null && this.green == null && this.blue == null) {
            throw new BeanMisconfiguredException("At least one of the channelProviderRed, channelProviderGreen or channelProviderBlue must be set");
        }
    }

    public Stack get() throws ProvisionFailedException {
        Channel channelRed = this.red != null ? (Channel)this.red.get() : null;
        Channel channelGreen = this.green != null ? (Channel)this.green.get() : null;
        Channel channelBlue = this.blue != null ? (Channel)this.blue.get() : null;
        VoxelDataType outputType = ThreeChannels.chooseOutputDataType(channelRed, channelGreen, channelBlue);
        return ThreeChannels.createRGBStack(channelRed, channelGreen, channelBlue, outputType);
    }

    public static Stack createRGBStack(Channel channelRed, Channel channelGreen, Channel channelBlue, VoxelDataType outputType) throws ProvisionFailedException {
        try {
            Dimensions dimensions = ThreeChannels.createDimensions(channelRed, channelGreen, channelBlue);
            Stack out = new Stack();
            ThreeChannels.addToStack(out, channelRed, dimensions, outputType);
            ThreeChannels.addToStack(out, channelGreen, dimensions, outputType);
            ThreeChannels.addToStack(out, channelBlue, dimensions, outputType);
            return out;
        }
        catch (IncorrectImageSizeException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    @Generated
    public ChannelProvider getRed() {
        return this.red;
    }

    @Generated
    public void setRed(ChannelProvider red) {
        this.red = red;
    }

    @Generated
    public ChannelProvider getGreen() {
        return this.green;
    }

    @Generated
    public void setGreen(ChannelProvider green) {
        this.green = green;
    }

    @Generated
    public ChannelProvider getBlue() {
        return this.blue;
    }

    @Generated
    public void setBlue(ChannelProvider blue) {
        this.blue = blue;
    }
}

