/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.object;

import java.awt.Color;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.shared.color.RGBColorBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.StreamableCollection;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.box.ScaleableBackground;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.BackgroundSelector;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.FlattenAndScaler;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ThumbnailBatchOutline;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ThumbnailFromObjects;
import org.anchoranalysis.plugin.image.thumbnail.ThumbnailBatch;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class OutlinePreserveRelativeSize
extends ThumbnailFromObjects {
    @BeanField
    private SizeXY size = new SizeXY(200, 200);
    @BeanField
    private int backgroundChannelIndex = -1;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    @BeanField
    private int outlineWidth = 3;
    @BeanField
    @OptionalBean
    private RGBColorBean colorUnselectedObjects;
    @BeanField
    @OptionalBean
    private boolean overlappingObjects = true;
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;

    public static OutlinePreserveRelativeSize createToColorUnselectedObjects(Interpolator interpolator) {
        OutlinePreserveRelativeSize out = new OutlinePreserveRelativeSize();
        out.colorUnselectedObjects = new RGBColorBean(Color.BLUE);
        out.interpolator = interpolator;
        return out;
    }

    @Override
    public ThumbnailBatch<ObjectCollection> start(ObjectCollection objects, StreamableCollection<BoundingBox> boundingBoxes, Optional<Stack> backgroundSource, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        if (!objects.isEmpty()) {
            VoxelsResizer resizerBackground = this.interpolator.voxelsResizer();
            FlattenAndScaler scaler = new FlattenAndScaler(boundingBoxes, objects, this.overlappingObjects, resizerBackground, this.size.asExtent(), (CheckedFunction<ScaleFactor, Optional<ScaleableBackground>, OperationFailedException>)((CheckedFunction)scaleFactor -> this.determineBackgroundMaybeOutlined((ScaleFactor)scaleFactor, backgroundSource, resizerBackground)));
            return new ThumbnailBatchOutline(scaler, objects, this.size.asExtent(), this.outlineWidth, this.colorForUnselectedObjects(), executionTimeRecorder);
        }
        return objectForBatch -> {
            throw new CreateException("No objects are expected in this batch");
        };
    }

    private Optional<Color> colorForUnselectedObjects() {
        return Optional.ofNullable(this.colorUnselectedObjects).map(RGBColorBean::toAWTColor);
    }

    private Optional<ScaleableBackground> determineBackgroundMaybeOutlined(ScaleFactor scaleFactor, Optional<Stack> backgroundSource, VoxelsResizer resizer) throws OperationFailedException {
        BackgroundSelector backgroundHelper = new BackgroundSelector(this.backgroundChannelIndex, scaleFactor, resizer, this.displayer);
        return backgroundHelper.determineBackground(backgroundSource);
    }

    @Generated
    public OutlinePreserveRelativeSize() {
    }

    @Generated
    public SizeXY getSize() {
        return this.size;
    }

    @Generated
    public void setSize(SizeXY size) {
        this.size = size;
    }

    @Generated
    public int getBackgroundChannelIndex() {
        return this.backgroundChannelIndex;
    }

    @Generated
    public void setBackgroundChannelIndex(int backgroundChannelIndex) {
        this.backgroundChannelIndex = backgroundChannelIndex;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Generated
    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    @Generated
    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    @Generated
    public RGBColorBean getColorUnselectedObjects() {
        return this.colorUnselectedObjects;
    }

    @Generated
    public void setColorUnselectedObjects(RGBColorBean colorUnselectedObjects) {
        this.colorUnselectedObjects = colorUnselectedObjects;
    }

    @Generated
    public boolean isOverlappingObjects() {
        return this.overlappingObjects;
    }

    @Generated
    public void setOverlappingObjects(boolean overlappingObjects) {
        this.overlappingObjects = overlappingObjects;
    }

    @Generated
    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    @Generated
    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

