/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.intensity;

import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.arithmetic.RunningSum;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class IntensityMeanCalculator {
    public static double calculateMeanIntensityObject(Channel channel, ObjectMask object) throws FeatureCalculationException {
        return IntensityMeanCalculator.calculateMeanIntensityObject(channel, object, false);
    }

    public static double calculateMeanIntensityObject(Channel channel, ObjectMask object, boolean excludeZero) throws FeatureCalculationException {
        IntensityMeanCalculator.checkContained(object.boundingBox(), channel.extent());
        RunningSum running = new RunningSum();
        IterateVoxelsObjectMask.withVoxelBuffer((ObjectMask)object, (Voxels)channel.voxels().any(), (buffer, offset) -> {
            int value = buffer.getInt(offset);
            if (!excludeZero || value != 0) {
                running.increment((double)value, 1L);
            }
        });
        if (running.getCount() == 0L) {
            throw new FeatureCalculationException("There are 0 pixels in the object-mask");
        }
        return running.mean();
    }

    private static void checkContained(BoundingBox box, Extent extent) throws FeatureCalculationException {
        if (!extent.contains(box)) {
            throw new FeatureCalculationException(String.format("The object's bounding-box (%s) is not contained within the dimensions of the channel %s", box, extent));
        }
    }

    @Generated
    private IntensityMeanCalculator() {
    }
}

