/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.intensity.level;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalDilation;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.intensity.level.LevelResult;
import org.anchoranalysis.plugin.image.intensity.level.LevelResultCollection;

public class LevelResultCollectionFactory {
    public static LevelResultCollection createCollection(Channel channel, ObjectCollection objects, CalculateLevel calculateLevel, int numberDilations, MessageLogger logger) throws CreateException {
        LevelResultCollection all = new LevelResultCollection();
        for (ObjectMask objectMask : objects) {
            int level;
            logger.logFormatted("Creating level result %s", new Object[]{objectMask.centerOfGravity().toString()});
            ObjectMask objectForCalculateLevel = numberDilations != 0 ? MorphologicalDilation.dilate((ObjectMask)objectMask, Optional.of(channel.extent()), (channel.dimensions().z() > 1 ? 1 : 0) != 0, (int)numberDilations, (boolean)false) : objectMask;
            Histogram histogram = HistogramFromObjectsFactory.createFrom((Channel)channel, (ObjectMask)objectForCalculateLevel);
            try {
                level = calculateLevel.calculateLevel(histogram);
            }
            catch (OperationFailedException e) {
                throw new CreateException((Throwable)e);
            }
            LevelResult result = new LevelResult(level, objectMask, histogram);
            logger.logFormatted("Level result is %d", new Object[]{result.getLevel()});
            all.add(result);
        }
        return all;
    }

    @Generated
    private LevelResultCollectionFactory() {
    }
}

