/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge;

import lombok.Generated;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.plugin.image.object.merge.NeighborGraph;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;

public class DescribeGraph {
    private NeighborGraph graph;
    private boolean includePayload;

    public String describe() {
        StringBuilder sb = new StringBuilder();
        this.describeAllVertices(sb);
        this.describeAllEdges(sb);
        return sb.toString();
    }

    public String describeEdge(ObjectVertex source, ObjectVertex destination, ObjectVertex merged, double priority, boolean doMerge) {
        if (this.includePayload) {
            return String.format("Merge? %s (%f)\t+%s (%f)\t= %s (%f)\t%e  %s", source.getObject(), source.getPayload(), destination.getObject(), destination.getPayload(), merged.getObject(), merged.getPayload(), priority, doMerge ? "Yes!" : "No!");
        }
        return String.format("Merge? %s\t+%s\t= %s\t%e  %s", source.getObject(), destination.getObject(), merged.getObject(), priority, doMerge ? "Yes!" : "No!");
    }

    public String describeMerge(ObjectVertex merged, TypedEdge<ObjectVertex, PrioritisedVertex> bestImprovement) {
        if (this.includePayload) {
            return String.format("Merging %s and %s to %s (%f,%f->%f). Num vertices=%d.", ((ObjectVertex)bestImprovement.getFrom()).getObject().centerOfGravity(), ((ObjectVertex)bestImprovement.getTo()).getObject().centerOfGravity(), merged.getObject().centerOfGravity(), ((ObjectVertex)bestImprovement.getFrom()).getPayload(), ((ObjectVertex)bestImprovement.getTo()).getPayload(), merged.getPayload(), this.graph.numberVertices());
        }
        return String.format("Merging %s and %s to %s. Num vertices=%d.", ((ObjectVertex)bestImprovement.getFrom()).getObject().centerOfGravity(), ((ObjectVertex)bestImprovement.getTo()).getObject().centerOfGravity(), merged.getObject().centerOfGravity(), this.graph.numberVertices());
    }

    private void describeAllVertices(StringBuilder builder) {
        builder.append("START Vertices\n");
        for (ObjectVertex vertex : this.graph.vertexSet()) {
            builder.append(String.format("%s (%f)%n", vertex.getObject().centerOfGravity(), vertex.getPayload()));
        }
        builder.append("END Vertices\n");
    }

    private void describeAllEdges(StringBuilder builder) {
        builder.append("START Edges\n");
        for (TypedEdge<ObjectVertex, PrioritisedVertex> edge : this.graph.edgeSetUnique()) {
            builder.append(this.describeEdge((ObjectVertex)edge.getFrom(), (ObjectVertex)edge.getTo(), ((PrioritisedVertex)edge.getPayload()).getVertex(), ((PrioritisedVertex)edge.getPayload()).getPriority(), ((PrioritisedVertex)edge.getPayload()).isConsiderForMerge()));
            builder.append("\n");
        }
        builder.append("END Edges");
    }

    @Generated
    public DescribeGraph(NeighborGraph graph, boolean includePayload) {
        this.graph = graph;
        this.includePayload = includePayload;
    }
}

