/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.arithmetic.DoubleUtilities;
import org.anchoranalysis.plugin.image.object.merge.DescribeGraph;
import org.anchoranalysis.plugin.image.object.merge.GraphLogger;
import org.anchoranalysis.plugin.image.object.merge.NeighborGraph;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.PayloadCalculator;
import org.anchoranalysis.plugin.image.object.merge.condition.UpdatableBeforeCondition;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;
import org.anchoranalysis.spatial.point.Comparator3i;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.Tuple3i;

public class MergeGraph {
    private PayloadCalculator payloadCalculator;
    private NeighborGraph graph;
    private GraphLogger logger;
    private AssignPriority prioritizer;

    public MergeGraph(PayloadCalculator payloadCalculator, UpdatableBeforeCondition beforeCondition, Optional<UnitConverter> unitConverter, AssignPriority prioritizer, Logger logger, boolean logPayload) {
        this.payloadCalculator = payloadCalculator;
        this.prioritizer = prioritizer;
        this.graph = new NeighborGraph(beforeCondition, unitConverter);
        this.logger = new GraphLogger(new DescribeGraph(this.graph, logPayload), logger);
    }

    public List<ObjectVertex> addObjectsToGraph(ObjectCollection objects) throws OperationFailedException {
        ArrayList<ObjectVertex> listAdded = new ArrayList<ObjectVertex>();
        for (int i = 0; i < objects.size(); ++i) {
            ObjectVertex vertex = this.createVertex(objects.get(i));
            this.graph.addVertex(vertex, listAdded, this.prioritizer, this.logger);
            listAdded.add(vertex);
        }
        return listAdded;
    }

    public ObjectVertex merge(TypedEdge<ObjectVertex, PrioritisedVertex> bestImprovement) throws OperationFailedException {
        Set<ObjectVertex> setPossibleNeighbors = this.graph.neighborNodesFor(bestImprovement);
        this.graph.removeVertex((ObjectVertex)bestImprovement.getFrom());
        this.graph.removeVertex((ObjectVertex)bestImprovement.getTo());
        ObjectVertex omMerged = ((PrioritisedVertex)bestImprovement.getPayload()).getVertex();
        this.graph.addVertex(omMerged, setPossibleNeighbors, this.prioritizer, this.logger);
        this.logger.describeMerge(omMerged, bestImprovement);
        return omMerged;
    }

    public TypedEdge<ObjectVertex, PrioritisedVertex> findMaxPriority() {
        TypedEdge<ObjectVertex, PrioritisedVertex> max = null;
        Comparator3i comparator = new Comparator3i();
        for (TypedEdge<ObjectVertex, PrioritisedVertex> entry : this.graph.edgeSetUnique()) {
            int cmp;
            PrioritisedVertex edge = (PrioritisedVertex)entry.getPayload();
            if (!edge.isConsiderForMerge()) continue;
            if (max == null || edge.getPriority() > ((PrioritisedVertex)max.getPayload()).getPriority()) {
                max = entry;
                continue;
            }
            if (!DoubleUtilities.areEqual((double)edge.getPriority(), (double)((PrioritisedVertex)max.getPayload()).getPriority()) || (cmp = comparator.compare((Tuple3i)((Point3i)((PrioritisedVertex)max.getPayload()).getVertex().getObject().findArbitraryOnVoxel().get()), (Tuple3i)((Point3i)edge.getVertex().getObject().findArbitraryOnVoxel().get()))) <= 0) continue;
            max = entry;
        }
        return max;
    }

    public void logGraphDescription() {
        this.logger.logDescription();
    }

    public ObjectCollection verticesAsObjects() {
        return this.graph.verticesAsObjects();
    }

    private ObjectVertex createVertex(ObjectMask mask) throws OperationFailedException {
        try {
            return new ObjectVertex(mask, this.payloadCalculator.calculate(mask));
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

