/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge.condition;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.bean.unitvalue.distance.UnitValueDistance;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.object.merge.condition.BeforeCondition;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.BoundingBoxDistance;
import org.anchoranalysis.spatial.point.Point3d;

public class DistanceCondition
implements BeforeCondition {
    private final Optional<UnitValueDistance> maxDistance;
    private final boolean suppressZ;
    private final MessageLogger logger;

    @Override
    public boolean accept(ObjectMask source, ObjectMask destination, Optional<UnitConverter> unitConverter) throws OperationFailedException {
        if (this.maxDistance.isPresent()) {
            return this.isWithinMaxDistance(source, destination, unitConverter);
        }
        return true;
    }

    private boolean isWithinMaxDistance(ObjectMask source, ObjectMask destination, Optional<UnitConverter> unitConverter) throws OperationFailedException {
        double maxDistanceResolved;
        double distance = BoundingBoxDistance.distance((BoundingBox)source.boundingBox(), (BoundingBox)destination.boundingBox(), (!this.suppressZ ? 1 : 0) != 0);
        if (distance >= (maxDistanceResolved = this.resolveDistance(unitConverter, source.boundingBox().midpoint(), destination.boundingBox().midpoint()))) {
            return false;
        }
        this.logger.logFormatted("Maybe merging %s and %s with distance %f (<%f)", new Object[]{source.boundingBox().midpoint(), destination.boundingBox().midpoint(), distance, maxDistanceResolved});
        return true;
    }

    private double resolveDistance(Optional<UnitConverter> unitConverter, Point3d point1, Point3d point2) throws OperationFailedException {
        if (this.suppressZ) {
            return this.maxDistance.get().resolve(unitConverter, point1.dropZ(), point2.dropZ());
        }
        return this.maxDistance.get().resolve(unitConverter, point1, point2);
    }

    @Generated
    public DistanceCondition(Optional<UnitValueDistance> maxDistance, boolean suppressZ, MessageLogger logger) {
        this.maxDistance = maxDistance;
        this.suppressZ = suppressZ;
        this.logger = logger;
    }
}

