/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge.priority;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.relation.DoubleBiPredicate;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;

public class AssignPriorityFromPair
extends AssignPriority {
    private final FeatureCalculatorSingle<FeatureInputPairObjects> featureCalculator;
    private final double threshold;
    private final DoubleBiPredicate relation;

    @Override
    public PrioritisedVertex assignPriorityToEdge(ObjectVertex source, ObjectVertex destination, ObjectMask merged, ErrorReporter errorReporter) throws OperationFailedException {
        double resultPair = this.featureCalculator.calculateSuppressErrors((FeatureInput)this.createInput(source, destination, merged), errorReporter);
        return new PrioritisedVertex(merged, 0.0, resultPair, this.relation.test(resultPair, this.threshold));
    }

    private FeatureInputPairObjects createInput(ObjectVertex sourceWithFeature, ObjectVertex destinationWithFeature, ObjectMask merged) {
        return new FeatureInputPairObjects(sourceWithFeature.getObject(), destinationWithFeature.getObject(), Optional.empty(), Optional.of(merged));
    }

    @Generated
    public AssignPriorityFromPair(FeatureCalculatorSingle<FeatureInputPairObjects> featureCalculator, double threshold, DoubleBiPredicate relation) {
        this.featureCalculator = featureCalculator;
        this.threshold = threshold;
        this.relation = relation;
    }
}

