/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.thresholder.slice;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.segment.thresholder.slice.SliceThresholder;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class SliceThresholderMask
extends SliceThresholder {
    private final boolean clearOutsideMask;
    private final ObjectMask object;
    private final ReadableTuple3i cornerMin;
    private final ReadableTuple3i cornerMax;

    public SliceThresholderMask(boolean clearOutsideMask, ObjectMask object, BinaryValuesByte binaryValues) {
        super(binaryValues);
        this.clearOutsideMask = clearOutsideMask;
        this.object = object;
        this.cornerMin = object.boundingBox().cornerMin();
        this.cornerMax = object.boundingBox().calculateCornerMaxInclusive();
    }

    @Override
    public void segmentAll(Voxels<?> voxelsIn, Voxels<?> voxelsThreshold, Voxels<UnsignedByteBuffer> voxelsOut) {
        for (int z = this.cornerMin.z(); z <= this.cornerMax.z(); ++z) {
            int relZ = z - this.cornerMin.z();
            this.sgmnSlice(voxelsIn.extent(), voxelsIn.slice(relZ), voxelsThreshold.slice(relZ), (VoxelBuffer<UnsignedByteBuffer>)voxelsOut.slice(relZ), (VoxelBuffer<UnsignedByteBuffer>)this.object.voxels().slice(z), this.object.binaryValuesByte());
        }
    }

    private void sgmnSlice(Extent extent, VoxelBuffer<?> voxelsIn, VoxelBuffer<?> voxelsThreshold, VoxelBuffer<UnsignedByteBuffer> voxelsOut, VoxelBuffer<UnsignedByteBuffer> voxelsMask, BinaryValuesByte binaryValuesMask) {
        int offsetMask = 0;
        UnsignedByteBuffer out = (UnsignedByteBuffer)voxelsOut.buffer();
        for (int y = this.cornerMin.y(); y <= this.cornerMax.y(); ++y) {
            for (int x = this.cornerMin.x(); x <= this.cornerMax.x(); ++x) {
                int offset = extent.offset(x, y);
                if (((UnsignedByteBuffer)voxelsMask.buffer()).getRaw(offsetMask++) == binaryValuesMask.getOff()) {
                    if (!this.clearOutsideMask) continue;
                    this.writeOffByte(offset, out);
                    continue;
                }
                this.writeThresholdedByte(offset, out, voxelsIn, voxelsThreshold);
            }
        }
    }
}

