/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.thresholder.slice;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.plugin.image.segment.thresholder.slice.SliceThresholder;
import org.anchoranalysis.spatial.box.Extent;

public class SliceThresholderWithoutMask
extends SliceThresholder {
    public SliceThresholderWithoutMask(BinaryValuesByte binaryValues) {
        super(binaryValues);
    }

    @Override
    public void segmentAll(Voxels<?> voxelsIn, Voxels<?> voxelsThreshold, Voxels<UnsignedByteBuffer> voxelsOut) {
        for (int z = 0; z < voxelsIn.extent().z(); ++z) {
            this.segmentSlice(voxelsIn.extent(), voxelsIn.slice(z), voxelsThreshold.slice(z), (VoxelBuffer<UnsignedByteBuffer>)voxelsOut.slice(z));
        }
    }

    private void segmentSlice(Extent extent, VoxelBuffer<?> voxelsIn, VoxelBuffer<?> voxelsThreshold, VoxelBuffer<UnsignedByteBuffer> bufferOut) {
        UnsignedByteBuffer out = (UnsignedByteBuffer)bufferOut.buffer();
        int offset = 0;
        for (int y = 0; y < extent.y(); ++y) {
            for (int x = 0; x < extent.x(); ++x) {
                this.writeThresholdedByte(offset, out, voxelsIn, voxelsThreshold);
                ++offset;
            }
        }
    }
}

