/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.watershed.encoding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedIntBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.WatershedEncoding;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public final class EncodedVoxels {
    public static final WatershedEncoding ENCODING = new WatershedEncoding();
    private final Voxels<UnsignedIntBuffer> voxels;

    public void setPoint(Point3i point, int code) {
        int offset = this.voxels.extent().offset(point.x(), point.y());
        ((UnsignedIntBuffer)this.voxels.sliceBuffer(point.z())).putRaw(offset, code);
    }

    public void setPointConnectedComponentID(Point3i point, int connectedComponentID) {
        this.setPoint(point, ENCODING.encodeConnectedComponentID(connectedComponentID));
    }

    public void setPointDirection(Point3i point, int xChange, int yChange, int zChange) {
        this.setPoint(point, ENCODING.encodeDirection(xChange, yChange, zChange));
    }

    public void pointListAtFirstPoint(List<Point3i> points) {
        Point3i rootPoint = points.get(0);
        int rootPointOffsetEncoded = ENCODING.encodeConnectedComponentID(this.voxels.extent().offset((ReadableTuple3i)rootPoint));
        this.setPoint(rootPoint, rootPointOffsetEncoded);
        for (int i = 1; i < points.size(); ++i) {
            this.setPoint(points.get(i), rootPointOffsetEncoded);
        }
    }

    public EncodedIntBuffer getPixelsForPlane(int z) {
        return new EncodedIntBuffer((UnsignedIntBuffer)this.voxels.sliceBuffer(z), ENCODING);
    }

    public boolean hasTemporary() {
        int volumeXY = this.extent().areaXY();
        for (int z = 0; z < this.extent().z(); ++z) {
            EncodedIntBuffer buffer = this.getPixelsForPlane(z);
            for (int i = 0; i < volumeXY; ++i) {
                if (!buffer.isTemporary(i)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Point3i> getTemporary() {
        ArrayList<Point3i> listOut = new ArrayList<Point3i>();
        for (int z = 0; z < this.extent().z(); ++z) {
            EncodedIntBuffer buffer = this.getPixelsForPlane(z);
            int offset = 0;
            for (int y = 0; y < this.extent().y(); ++y) {
                for (int x = 0; x < this.extent().x(); ++x) {
                    if (!buffer.isTemporary(offset++)) continue;
                    listOut.add(new Point3i(x, y, z));
                }
            }
        }
        return listOut;
    }

    public Set<Integer> setOfConnectedComponentIDs() {
        HashSet<Integer> setOut = new HashSet<Integer>();
        for (int z = 0; z < this.extent().z(); ++z) {
            EncodedIntBuffer buffer = this.getPixelsForPlane(z);
            int offset = 0;
            for (int y = 0; y < this.extent().y(); ++y) {
                for (int x = 0; x < this.extent().x(); ++x) {
                    if (buffer.isConnectedComponentID(offset)) {
                        setOut.add(buffer.getCode(offset));
                    }
                    ++offset;
                }
            }
        }
        return setOut;
    }

    public int calculateConnectedComponentID(Point3i point, int firstChainCode) {
        Extent extent = this.voxels.extent();
        int crntChainCode = firstChainCode;
        while (true) {
            point = this.addDirectionFromChainCode(point, crntChainCode);
            assert (extent.contains((ReadableTuple3i)point));
            int nextVal = ((UnsignedIntBuffer)this.voxels.sliceBuffer(point.z())).getRaw(extent.offsetSlice((ReadableTuple3i)point));
            assert (nextVal != 0);
            assert (nextVal != 1);
            if (ENCODING.isConnectedComponentIDCode(nextVal)) {
                return nextVal;
            }
            if (nextVal == 2) {
                return ENCODING.encodeConnectedComponentID(extent.offset((ReadableTuple3i)point));
            }
            crntChainCode = nextVal;
        }
    }

    private Point3i addDirectionFromChainCode(Point3i point, int chainCode) {
        Point3i out = ENCODING.chainCodes(chainCode);
        out.add((ReadableTuple3i)point);
        return out;
    }

    public boolean isPlateau(int code) {
        return code == 3;
    }

    public boolean isMinima(int code) {
        return code == 2;
    }

    public boolean isTemporary(int code) {
        return code == 1;
    }

    public boolean isUnvisited(int code) {
        return code == 0;
    }

    public boolean isDirectionChainCode(int code) {
        return ENCODING.isDirectionChainCode(code);
    }

    public boolean isConnectedComponentIDCode(int code) {
        return ENCODING.isConnectedComponentIDCode(code);
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    @Generated
    public EncodedVoxels(Voxels<UnsignedIntBuffer> voxels) {
        this.voxels = voxels;
    }

    @Generated
    public Voxels<UnsignedIntBuffer> voxels() {
        return this.voxels;
    }
}

