/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.watershed.encoding;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;

public class PriorityQueueIndexRangeDownhill<T> {
    private List<T>[] lists;
    private int nextIndexValue = -1;
    private List<T> nextList;

    public PriorityQueueIndexRangeDownhill(int maxPossibleValue) {
        Preconditions.checkArgument((maxPossibleValue >= 0 ? 1 : 0) != 0);
        this.lists = new List[maxPossibleValue + 1];
        for (int i = 0; i <= maxPossibleValue; ++i) {
            this.lists[i] = new LinkedList<T>();
        }
    }

    public void put(T item, int indexValue) {
        List<T> list = this.lists[indexValue];
        this.lists[indexValue].add(item);
        if (indexValue > this.nextIndexValue) {
            this.nextIndexValue = indexValue;
            this.nextList = list;
        }
    }

    public boolean hasNext() {
        return this.nextList != null;
    }

    public int nextValue() {
        return this.nextIndexValue;
    }

    public T get() {
        T ret = this.nextList.remove(0);
        if (this.nextList.isEmpty()) {
            this.calculateNewMaxCurrentValue();
        }
        return ret;
    }

    private void calculateNewMaxCurrentValue() {
        for (int i = this.nextIndexValue - 1; i >= 0; --i) {
            List<T> list = this.lists[i];
            if (list.isEmpty()) continue;
            this.nextIndexValue = i;
            this.nextList = list;
            return;
        }
        this.nextIndexValue = -1;
        this.nextList = null;
    }
}

