/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.object.provider;

import java.util.Optional;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProviderUnary;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.imagej.mask.ApplyImageJMorphologicalOperation;

public class FillHoles
extends ObjectCollectionProviderUnary {
    @BeanField
    @OptionalBean
    private MaskProvider mask;

    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        Optional maskChannel = OptionalProviderFactory.create((Provider)this.mask);
        for (ObjectMask objectMask : objects) {
            BinaryVoxels voxels = objectMask.binaryVoxels();
            BinaryVoxels voxelsDuplicated = voxels.duplicate();
            try {
                ApplyImageJMorphologicalOperation.fill((BinaryVoxels<UnsignedByteBuffer>)voxelsDuplicated);
            }
            catch (OperationFailedException e) {
                throw new ProvisionFailedException((Throwable)e);
            }
            if (!maskChannel.isPresent()) continue;
            ObjectMask objectRegion = ((Mask)maskChannel.get()).region(objectMask.boundingBox(), true);
            ObjectMask objectRegionAtOrigin = objectRegion.shiftToOrigin();
            voxelsDuplicated.extract().objectCopyTo(objectRegionAtOrigin, voxels.voxels(), objectRegionAtOrigin.boundingBox());
        }
        return objects;
    }

    public MaskProvider getMask() {
        return this.mask;
    }

    public void setMask(MaskProvider mask) {
        this.mask = mask;
    }
}

