/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.object.segment;

import ij.process.ImageProcessor;
import java.util.Collection;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.label.DecodeLabels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.plugin.imagej.bean.object.segment.FloodFillHelper;

public class FloodFillEachIntensityLevel
extends SegmentChannelIntoObjects {
    @BeanField
    private int minimumBoundingBoxVolume = 1;
    @BeanField
    private int startingIntensity = 1;

    public ObjectCollection segment(Channel channel, Optional<ObjectMask> objectMask, Optional<ObjectCollection> seeds) throws SegmentationFailedException {
        FloodFillEachIntensityLevel.checkUnsupportedObjectMask(objectMask);
        FloodFillEachIntensityLevel.checkUnsupportedSeeds(seeds);
        FloodFillEachIntensityLevel.checkUnsupported3D((Channel)channel);
        try {
            int numberColors = this.floodFillChannel(channel);
            return this.objectsFromLabels(channel, numberColors);
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
    }

    private int floodFillChannel(Channel channel) throws OperationFailedException {
        ImageProcessor imageProcessor = ConvertToImageProcessor.fromByte((SliceBufferIndex)channel.voxels().asByte().slices(), (int)0);
        FloodFillHelper helper = new FloodFillHelper(this.minimumBoundingBoxVolume, BinaryValuesByte.getDefault().getOn(), imageProcessor);
        return helper.floodFill2D(this.startingIntensity);
    }

    private ObjectCollection objectsFromLabels(Channel channel, int numberLabels) throws OperationFailedException {
        try {
            DecodeLabels createObjects = new DecodeLabels(channel.voxels().asByte(), 1, numberLabels, (index, scaledObject) -> scaledObject);
            return ObjectCollectionFactory.of((Collection[])new Collection[]{createObjects.create(this.minimumBoundingBoxVolume)});
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public int getMinimumBoundingBoxVolume() {
        return this.minimumBoundingBoxVolume;
    }

    public void setMinimumBoundingBoxVolume(int minimumBoundingBoxVolume) {
        this.minimumBoundingBoxVolume = minimumBoundingBoxVolume;
    }

    public int getStartingIntensity() {
        return this.startingIntensity;
    }

    public void setStartingIntensity(int startingIntensity) {
        this.startingIntensity = startingIntensity;
    }
}

