/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.threshold;

import ij.Prefs;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.Thresholder;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.thresholder.VoxelsThresholder;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.imagej.mask.ApplyImageJMorphologicalOperation;

public class ThresholderSimpleFillHoles2D
extends Thresholder {
    @BeanField
    private int minIntensity = -1;

    public BinaryVoxels<UnsignedByteBuffer> threshold(VoxelsUntyped inputBuffer, BinaryValuesByte binaryValues, Optional<Histogram> histogram, Optional<ObjectMask> objectMask) throws OperationFailedException {
        if (objectMask.isPresent()) {
            throw new OperationFailedException("A mask is not supported for this operation");
        }
        BinaryVoxels thresholded = VoxelsThresholder.threshold((VoxelsUntyped)inputBuffer, (float)this.minIntensity, (BinaryValuesByte)binaryValues, objectMask, (boolean)false);
        ApplyImageJMorphologicalOperation.applyOperation((BinaryVoxels<UnsignedByteBuffer>)thresholded, "fill", 1);
        return thresholded;
    }

    public ThresholderSimpleFillHoles2D() {
    }

    public ThresholderSimpleFillHoles2D(int minIntensity) {
        this.minIntensity = minIntensity;
    }

    public int getMinIntensity() {
        return this.minIntensity;
    }

    public void setMinIntensity(int minIntensity) {
        this.minIntensity = minIntensity;
    }

    static {
        Prefs.blackBackground = true;
    }
}

