/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.channel.provider;

import ij.plugin.filter.RankFilters;
import ij.process.ImageProcessor;
import java.util.function.Consumer;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;

public class FilterHelper {
    public static Channel applyRankFilter(Channel channel, int radius, int filterType) throws OperationFailedException {
        try {
            RankFilters rankFilters = new RankFilters();
            FilterHelper.processEachSlice(channel, (ImageProcessor processor) -> rankFilters.rank(processor, (double)radius, filterType));
            return channel;
        }
        catch (ImageJConversionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public static void processEachSlice(Channel channel, Consumer<ImageProcessor> consumer) throws ImageJConversionException {
        VoxelsUntyped voxels = channel.voxels();
        channel.extent().iterateOverZ(z -> {
            ImageProcessor processor = ConvertToImageProcessor.from((VoxelsUntyped)voxels, (int)z);
            consumer.accept(processor);
        });
    }

    public static void processEachSlice(BinaryVoxels<UnsignedByteBuffer> voxels, Consumer<ImageProcessor> consumer) {
        SliceBufferIndex slices = voxels.slices();
        voxels.extent().iterateOverZ(z -> {
            ImageProcessor processor = ConvertToImageProcessor.fromByte((SliceBufferIndex)slices, (int)z);
            consumer.accept(processor);
        });
    }

    private FilterHelper() {
    }
}

