/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.channel.provider;

import ij.ImagePlus;
import ij.plugin.filter.BackgroundSubtracter;
import java.util.Optional;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.io.imagej.convert.ConvertFromImagePlus;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.plugin.imagej.bean.channel.provider.WithRadiusBase;
import org.anchoranalysis.spatial.box.Extent;

public class BackgroundSubtractor
extends WithRadiusBase {
    @Override
    protected Channel createFromChannel(Channel channel, int radius) throws ProvisionFailedException {
        try {
            ImagePlus image = ConvertToImagePlus.from((Channel)channel);
            this.subtractBackground(image, channel.extent(), radius);
            return ConvertFromImagePlus.toChannel((ImagePlus)image, (Optional)channel.resolution());
        }
        catch (ImageJConversionException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private void subtractBackground(ImagePlus image, Extent extent, int radius) {
        BackgroundSubtracter plugin = new BackgroundSubtracter();
        extent.iterateOverZ(z -> plugin.rollingBallBackground(image.getStack().getProcessor(z + 1), (double)radius, false, false, false, true, true));
    }
}

