/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.channel.provider;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.UnitConverter;

public abstract class WithRadiusBase
extends ChannelProviderUnary {
    @BeanField
    @Positive
    private double radius = 2.0;
    @BeanField
    private boolean radiusInMeters = false;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        return this.createFromChannel(channel, this.radiusInVoxels(channel.resolution().map(Resolution::unitConvert)));
    }

    protected abstract Channel createFromChannel(Channel var1, int var2) throws ProvisionFailedException;

    private int radiusInVoxels(Optional<UnitConverter> converter) throws ProvisionFailedException {
        if (this.radiusInMeters) {
            if (converter.isPresent()) {
                return (int)Math.round(converter.get().fromPhysicalDistance(this.radius));
            }
            throw new ProvisionFailedException("Radius is specified in meters but no image-resolution information is available");
        }
        return (int)this.radius;
    }

    @Generated
    public double getRadius() {
        return this.radius;
    }

    @Generated
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Generated
    public boolean isRadiusInMeters() {
        return this.radiusInMeters;
    }

    @Generated
    public void setRadiusInMeters(boolean radiusInMeters) {
        this.radiusInMeters = radiusInMeters;
    }
}

