/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.define;

import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.define.DefineAddException;
import org.anchoranalysis.bean.define.adder.DefineAdderWithPrefixBean;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.plugin.image.bean.blur.BlurGaussian3D;
import org.anchoranalysis.plugin.image.bean.blur.BlurStrategy;
import org.anchoranalysis.plugin.image.bean.channel.provider.Reference;
import org.anchoranalysis.plugin.image.bean.channel.provider.gradient.GradientForAxis;
import org.anchoranalysis.plugin.image.bean.channel.provider.gradient.Sobel;
import org.anchoranalysis.plugin.image.bean.channel.provider.intensity.Blur;
import org.anchoranalysis.plugin.imagej.bean.channel.provider.filter.rank.MedianFilter2D;

public class AddEdgeFilters
extends DefineAdderWithPrefixBean {
    private static final String NAME_MEDIAN = "Median";
    private static final String NAME_GAUSSIAN = "Blurred";
    @BeanField
    private String channelID;
    @BeanField
    @Positive
    private double medianRadiusMeters = 0.0;
    @BeanField
    @Positive
    private double gaussianSigmaMeters = 0.0;
    @BeanField
    private boolean median = true;
    @BeanField
    private boolean gaussian = true;

    public void addTo(Define define) throws DefineAddException {
        if (this.median) {
            this.addFilterType(define, NAME_MEDIAN, (AnchorBean<?>)this.createMedian());
        }
        if (this.gaussian) {
            this.addFilterType(define, NAME_GAUSSIAN, (AnchorBean<?>)this.createGaussian());
        }
    }

    private void addFilterType(Define define, String filterName, AnchorBean<?> filterProvider) throws DefineAddException {
        this.addWithName(define, filterName, filterProvider);
        new GradientsForFilter(filterName).addTo(define);
    }

    private ChannelProvider createMedian() {
        MedianFilter2D provider = new MedianFilter2D();
        provider.setRadius((int)Math.round(this.medianRadiusMeters));
        provider.setRadiusInMeters(true);
        provider.setChannel(this.createDup(this.channelID));
        return provider;
    }

    private ChannelProvider createGaussian() {
        Blur provider = new Blur();
        provider.setStrategy(this.createBlurStrategy());
        provider.setChannel(this.createDup(this.channelID));
        return provider;
    }

    private BlurStrategy createBlurStrategy() {
        BlurGaussian3D blurStrategy = new BlurGaussian3D();
        blurStrategy.setSigma(this.gaussianSigmaMeters);
        blurStrategy.setSigmaInMeters(true);
        return blurStrategy;
    }

    private ChannelProvider createDup(String srcID) {
        Reference provider = new Reference();
        provider.setId(srcID);
        provider.setDuplicate(true);
        return provider;
    }

    @Generated
    public String getChannelID() {
        return this.channelID;
    }

    @Generated
    public void setChannelID(String channelID) {
        this.channelID = channelID;
    }

    @Generated
    public double getMedianRadiusMeters() {
        return this.medianRadiusMeters;
    }

    @Generated
    public void setMedianRadiusMeters(double medianRadiusMeters) {
        this.medianRadiusMeters = medianRadiusMeters;
    }

    @Generated
    public double getGaussianSigmaMeters() {
        return this.gaussianSigmaMeters;
    }

    @Generated
    public void setGaussianSigmaMeters(double gaussianSigmaMeters) {
        this.gaussianSigmaMeters = gaussianSigmaMeters;
    }

    @Generated
    public boolean isMedian() {
        return this.median;
    }

    @Generated
    public void setMedian(boolean median) {
        this.median = median;
    }

    @Generated
    public boolean isGaussian() {
        return this.gaussian;
    }

    @Generated
    public void setGaussian(boolean gaussian) {
        this.gaussian = gaussian;
    }

    private class GradientsForFilter {
        private String filterName;

        public void addTo(Define define) throws DefineAddException {
            this.addForFilter(define, "_Gradient_Magnitude", (AnchorBean<?>)this.edgeFilter(this.filterName));
            this.addForFilter(define, "_Gradient_X", (AnchorBean<?>)this.gradientSingleDimension("x"));
            this.addForFilter(define, "_Gradient_Y", (AnchorBean<?>)this.gradientSingleDimension("y"));
            this.addForFilter(define, "_Gradient_Second_Magnitude", (AnchorBean<?>)this.edgeFilter(this.filterName + "_Gradient_Magnitude"));
        }

        private void addForFilter(Define define, String suffix, AnchorBean<?> item) throws DefineAddException {
            AddEdgeFilters.this.addWithName(define, this.filterName + suffix, item);
        }

        private ChannelProvider edgeFilter(String unresolvedSrcName) {
            Sobel provider = new Sobel();
            provider.setOutputShort(true);
            provider.setChannel(AddEdgeFilters.this.createDup(AddEdgeFilters.this.resolveName(unresolvedSrcName)));
            return provider;
        }

        private ChannelProvider gradientSingleDimension(String axis) {
            GradientForAxis provider = new GradientForAxis();
            provider.setOutputShort(true);
            provider.setAddSum(32768);
            provider.setAxis(axis);
            provider.setChannel(AddEdgeFilters.this.createDup(AddEdgeFilters.this.resolveName(this.filterName)));
            return provider;
        }

        @Generated
        public GradientsForFilter(String filterName) {
            this.filterName = filterName;
        }
    }
}

