/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.object.provider;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.points.BoundingBoxFromPoints;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class WalkShortestPath {
    public static ObjectMask walkLine(Point3i point1, Point3i point2) throws OperationFailedException {
        return WalkShortestPath.walkLineInternal(Arrays.asList(point1, point2));
    }

    public static ObjectMask walkLine(List<Point3d> points) throws OperationFailedException {
        if (points.size() < 2) {
            throw new OperationFailedException(String.format("A minimum of two points is required to walk a line, but there are only %d points.", points.size()));
        }
        return WalkShortestPath.walkLineInternal(PointConverter.convert3i(points));
    }

    private static ObjectMask walkLineInternal(List<Point3i> points) throws OperationFailedException {
        WalkShortestPath.checkCoplanar(points);
        BoundingBox box = BoundingBoxFromPoints.fromStream(points.stream());
        ObjectMask object = new ObjectMask(box);
        for (int i = 0; i < points.size() - 1; ++i) {
            Point3i point1 = points.get(i);
            Point3i point2 = points.get(i + 1);
            assert (point1.z() == point2.z());
            WalkShortestPath.drawLineOnVoxelBuffer((VoxelBuffer<UnsignedByteBuffer>)object.binaryVoxels().slice(point1.z() - box.cornerMin().z()), object.binaryVoxels().extent(), object.binaryVoxels().binaryValues().asByte(), point1, point2, box.cornerMin());
        }
        return object;
    }

    private static void checkCoplanar(List<Point3i> points) throws OperationFailedException {
        Point3i firstPoint = null;
        for (Point3i point : points) {
            if (firstPoint == null) {
                firstPoint = point;
            }
            if (firstPoint.z() == point.z()) continue;
            throw new OperationFailedException(String.format("The first point in the list (%d) and another point (%d) have different z values. This algorithm only supports co-planar points (parallel to XY-axis)", firstPoint.z(), point.z()));
        }
    }

    private static void drawLineOnVoxelBuffer(VoxelBuffer<UnsignedByteBuffer> plane, Extent extent, BinaryValuesByte binaryValues, Point3i point1, Point3i point2, ReadableTuple3i cornerMin) {
        WalkShortestPath.drawLine4(plane, extent, binaryValues, point1.x() - cornerMin.x(), point1.y() - cornerMin.y(), point2.x() - cornerMin.x(), point2.y() - cornerMin.y());
    }

    private static void drawLine4(VoxelBuffer<UnsignedByteBuffer> plane, Extent extent, BinaryValuesByte binaryValues, int x1, int y1, int x2, int y2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sgnX = WalkShortestPath.sgn(x1, x2);
        int sgnY = WalkShortestPath.sgn(y1, y2);
        int e = 0;
        for (int i = 0; i < dx + dy; ++i) {
            WalkShortestPath.drawPoint(plane, extent, binaryValues, x1, y1);
            int e1 = e + dy;
            int e2 = e - dx;
            if (Math.abs(e1) < Math.abs(e2)) {
                x1 += sgnX;
                e = e1;
                continue;
            }
            y1 += sgnY;
            e = e2;
        }
        WalkShortestPath.drawPoint(plane, extent, binaryValues, x2, y2);
    }

    private static int sgn(int x1, int x2) {
        return x1 < x2 ? 1 : -1;
    }

    private static void drawPoint(VoxelBuffer<UnsignedByteBuffer> plane, Extent extent, BinaryValuesByte binaryValues, int x, int y) {
        plane.putByte(extent.offset(x, y), binaryValues.getOn());
    }

    @Generated
    private WalkShortestPath() {
    }
}

