/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.object.segment;

import ij.process.ImageProcessor;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.plugin.imagej.bean.object.segment.IJFloodFiller;

class FloodFillHelper {
    private final int minNumberPixels;
    private final int equalValueAsInt;
    private final ImageProcessor processor;
    private final IJFloodFiller floodFiller;

    public FloodFillHelper(int minNumberPixels, byte equalValueAsByte, ImageProcessor processor) {
        this.minNumberPixels = minNumberPixels;
        this.equalValueAsInt = PrimitiveConverter.unsignedByteToInt((byte)equalValueAsByte);
        this.processor = processor;
        this.floodFiller = new IJFloodFiller(processor);
    }

    public int floodFill2D(int startingColor) throws OperationFailedException {
        int color = startingColor - 1;
        for (int y = 0; y < this.processor.getHeight(); ++y) {
            for (int x = 0; x < this.processor.getWidth(); ++x) {
                if (this.processor.getPixel(x, y) != this.equalValueAsInt) continue;
                color = this.floodFillFromPoint(x, y, color);
            }
        }
        return color;
    }

    private int floodFillFromPoint(int x, int y, int color) throws OperationFailedException {
        if (color != this.equalValueAsInt) {
            ++color;
        }
        if (color == 255) {
            throw new OperationFailedException("More objects that colors (max of 254 allowed)");
        }
        this.processor.setColor(color);
        int numberFilledPixels = this.floodFiller.fill(x, y);
        if (numberFilledPixels < this.minNumberPixels) {
            this.processor.setColor(0);
            this.floodFiller.fill(x, y);
            --color;
        }
        return color;
    }

    @Generated
    public FloodFillHelper(int minNumberPixels, int equalValueAsInt, ImageProcessor processor, IJFloodFiller floodFiller) {
        this.minNumberPixels = minNumberPixels;
        this.equalValueAsInt = equalValueAsInt;
        this.processor = processor;
        this.floodFiller = floodFiller;
    }
}

