/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.channel.provider.filter.rank;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.text.NumberFormat;
import java.util.Arrays;

class Hybrid_3D_Median_Filter
implements PlugInFilter {
    private ImagePlus imp;
    private ImagePlus imp2;
    private ImageStack stack;
    private ImageStack stack2;
    private ImageProcessor ip;
    private ImageProcessor ip2;
    private boolean atebit = false;
    private boolean include = false;
    private NumberFormat nf = NumberFormat.getInstance();
    private double prognum;
    private String progstr;
    private String otitle;
    private String titlestring;
    private ImageWindow win;
    private boolean quit = false;

    Hybrid_3D_Median_Filter() {
    }

    public int setup(String argv, ImagePlus imp) {
        try {
            this.stack = imp.getStack();
        }
        catch (Exception e) {
            IJ.showMessage((String)"A stack must be open.");
            return 4096;
        }
        this.otitle = imp.getTitle();
        this.include = true;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.imp = imp;
        if (imp.getBitDepth() == 8) {
            this.atebit = true;
        }
        this.win = imp.getWindow();
        if (this.win != null) {
            this.win.running = true;
        }
        return 2309;
    }

    public void run(ImageProcessor ip) {
        this.imp2 = this.Hybrid3dMedianizer(this.imp);
        if (this.quit) {
            return;
        }
        this.imp2.getProcessor().resetMinAndMax();
    }

    public ImagePlus Hybrid3dMedianizer(ImagePlus imp) {
        short[] afterslice;
        short[] thisslice;
        short[] beforeslice;
        byte[] newslice8;
        byte[] afterslice8;
        byte[] thisslice8;
        byte[] beforeslice8;
        int m = this.stack.getWidth();
        int n = this.stack.getHeight();
        this.imp2 = new ImagePlus("3d Hybrid Median Filter", imp.getStack());
        this.stack2 = this.imp2.createEmptyStack();
        int dimension = m * n;
        int stacksize = this.stack.getSize();
        if (this.atebit) {
            beforeslice8 = new byte[dimension];
            thisslice8 = new byte[dimension];
            afterslice8 = new byte[dimension];
            newslice8 = new byte[dimension];
        } else {
            beforeslice = new short[dimension];
            thisslice = new short[dimension];
            afterslice = new short[dimension];
            short[] sArray = new short[dimension];
        }
        double[] dubbeforeslice = new double[dimension];
        double[] dubthisslice = new double[dimension];
        double[] dubafterslice = new double[dimension];
        double[] filteredslice = new double[dimension];
        double[] marraythisP = new double[5];
        double[] marraythisX = new double[5];
        double[] marray3P = new double[7];
        double[] marray3Xa = new double[5];
        double[] marray3Xb = new double[5];
        double[] marray3Xc = new double[5];
        double[] marray3Xd = new double[5];
        double[] medianarray = new double[7];
        if (this.include) {
            medianarray = new double[8];
        }
        for (int i = 1; i <= stacksize; ++i) {
            if (this.atebit) {
                try {
                    beforeslice8 = (byte[])this.stack.getPixels(i - 1);
                }
                catch (Exception e) {
                    beforeslice8 = (byte[])this.stack.getPixels(i);
                }
                thisslice8 = (byte[])this.stack.getPixels(i);
                try {
                    afterslice8 = (byte[])this.stack.getPixels(i + 1);
                }
                catch (Exception e) {
                    afterslice8 = (byte[])this.stack.getPixels(i);
                }
                dubbeforeslice = this.byte2double(beforeslice8);
                dubthisslice = this.byte2double(thisslice8);
                dubafterslice = this.byte2double(afterslice8);
            } else {
                try {
                    beforeslice = (short[])this.stack.getPixels(i - 1);
                }
                catch (Exception e) {
                    beforeslice = (short[])this.stack.getPixels(i);
                }
                thisslice = (short[])this.stack.getPixels(i);
                try {
                    afterslice = (short[])this.stack.getPixels(i + 1);
                }
                catch (Exception e) {
                    afterslice = (short[])this.stack.getPixels(i);
                }
                dubbeforeslice = this.short2double(beforeslice);
                dubthisslice = this.short2double(thisslice);
                dubafterslice = this.short2double(afterslice);
            }
            for (int j = 0; j < dimension; ++j) {
                try {
                    marraythisP[0] = dubthisslice[j - m];
                }
                catch (Exception e) {
                    marraythisP[0] = dubthisslice[j];
                }
                try {
                    marraythisP[1] = dubthisslice[j - 1];
                }
                catch (Exception e) {
                    marraythisP[1] = dubthisslice[j];
                }
                try {
                    marraythisP[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marraythisP[2] = dubthisslice[j];
                }
                try {
                    marraythisP[3] = dubthisslice[j + 1];
                }
                catch (Exception e) {
                    marraythisP[3] = dubthisslice[j];
                }
                try {
                    marraythisP[4] = dubthisslice[j + m];
                }
                catch (Exception e) {
                    marraythisP[4] = dubthisslice[j];
                }
                try {
                    marraythisX[0] = dubthisslice[j - (m + 1)];
                }
                catch (Exception e) {
                    marraythisX[0] = dubthisslice[j];
                }
                try {
                    marraythisX[1] = dubthisslice[j - (m - 1)];
                }
                catch (Exception e) {
                    marraythisX[1] = dubthisslice[j];
                }
                try {
                    marraythisX[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marraythisX[2] = dubthisslice[j];
                }
                try {
                    marraythisX[3] = dubthisslice[j + (m - 1)];
                }
                catch (Exception e) {
                    marraythisX[3] = dubthisslice[j];
                }
                try {
                    marraythisX[4] = dubthisslice[j + (m + 1)];
                }
                catch (Exception e) {
                    marraythisX[4] = dubthisslice[j];
                }
                try {
                    marray3P[0] = dubbeforeslice[j];
                }
                catch (Exception e) {
                    marray3P[0] = dubthisslice[j];
                }
                try {
                    marray3P[1] = dubthisslice[j - m];
                }
                catch (Exception e) {
                    marray3P[1] = dubthisslice[j];
                }
                try {
                    marray3P[2] = dubthisslice[j - 1];
                }
                catch (Exception e) {
                    marray3P[2] = dubthisslice[j];
                }
                try {
                    marray3P[3] = dubthisslice[j];
                }
                catch (Exception e) {
                    marray3P[3] = dubthisslice[j];
                }
                try {
                    marray3P[4] = dubthisslice[j + 1];
                }
                catch (Exception e) {
                    marray3P[4] = dubthisslice[j];
                }
                try {
                    marray3P[5] = dubthisslice[j + m];
                }
                catch (Exception e) {
                    marray3P[5] = dubthisslice[j];
                }
                try {
                    marray3P[6] = dubafterslice[j];
                }
                catch (Exception e) {
                    marray3P[6] = dubthisslice[j];
                }
                try {
                    marray3Xa[0] = dubbeforeslice[j - (m + 1)];
                }
                catch (Exception e) {
                    marray3Xa[0] = dubthisslice[j];
                }
                try {
                    marray3Xa[1] = dubafterslice[j + (m + 1)];
                }
                catch (Exception e) {
                    marray3Xa[1] = dubthisslice[j];
                }
                try {
                    marray3Xa[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marray3Xa[2] = dubthisslice[j];
                }
                try {
                    marray3Xa[3] = dubbeforeslice[j + (m - 1)];
                }
                catch (Exception e) {
                    marray3Xa[3] = dubthisslice[j];
                }
                try {
                    marray3Xa[4] = dubafterslice[j - (m - 1)];
                }
                catch (Exception e) {
                    marray3Xa[4] = dubthisslice[j];
                }
                try {
                    marray3Xb[0] = dubbeforeslice[j - m];
                }
                catch (Exception e) {
                    marray3Xb[0] = dubthisslice[j];
                }
                try {
                    marray3Xb[1] = dubafterslice[j + m];
                }
                catch (Exception e) {
                    marray3Xb[1] = dubthisslice[j];
                }
                try {
                    marray3Xb[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marray3Xb[2] = dubthisslice[j];
                }
                try {
                    marray3Xb[3] = dubbeforeslice[j + m];
                }
                catch (Exception e) {
                    marray3Xb[3] = dubthisslice[j];
                }
                try {
                    marray3Xb[4] = dubafterslice[j - m];
                }
                catch (Exception e) {
                    marray3Xb[4] = dubthisslice[j];
                }
                try {
                    marray3Xc[0] = dubbeforeslice[j - (m - 1)];
                }
                catch (Exception e) {
                    marray3Xc[0] = dubthisslice[j];
                }
                try {
                    marray3Xc[1] = dubafterslice[j + (m - 1)];
                }
                catch (Exception e) {
                    marray3Xc[1] = dubthisslice[j];
                }
                try {
                    marray3Xc[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marray3Xc[2] = dubthisslice[j];
                }
                try {
                    marray3Xc[3] = dubbeforeslice[j + (m - 1)];
                }
                catch (Exception e) {
                    marray3Xc[3] = dubthisslice[j];
                }
                try {
                    marray3Xc[4] = dubafterslice[j - (m - 1)];
                }
                catch (Exception e) {
                    marray3Xc[4] = dubthisslice[j];
                }
                try {
                    marray3Xd[0] = dubbeforeslice[j - 1];
                }
                catch (Exception e) {
                    marray3Xd[0] = dubthisslice[j];
                }
                try {
                    marray3Xd[1] = dubafterslice[j + 1];
                }
                catch (Exception e) {
                    marray3Xd[1] = dubthisslice[j];
                }
                try {
                    marray3Xd[2] = dubthisslice[j];
                }
                catch (Exception e) {
                    marray3Xd[2] = dubthisslice[j];
                }
                try {
                    marray3Xd[3] = dubbeforeslice[j + 1];
                }
                catch (Exception e) {
                    marray3Xd[3] = dubthisslice[j];
                }
                try {
                    marray3Xd[4] = dubafterslice[j - 1];
                }
                catch (Exception e) {
                    marray3Xd[4] = dubthisslice[j];
                }
                medianarray[0] = Hybrid_3D_Median_Filter.median(marraythisX);
                medianarray[1] = Hybrid_3D_Median_Filter.median(marraythisP);
                medianarray[2] = Hybrid_3D_Median_Filter.median(marray3P);
                medianarray[3] = Hybrid_3D_Median_Filter.median(marray3Xa);
                medianarray[4] = Hybrid_3D_Median_Filter.median(marray3Xb);
                medianarray[5] = Hybrid_3D_Median_Filter.median(marray3Xc);
                medianarray[6] = Hybrid_3D_Median_Filter.median(marray3Xd);
                if (this.include) {
                    medianarray[7] = dubthisslice[j];
                }
                filteredslice[j] = Hybrid_3D_Median_Filter.median(medianarray);
            }
            this.prognum = (double)(i - 1) / (double)stacksize;
            this.progstr = this.nf.format(100.0 * this.prognum);
            IJ.showStatus((String)("3d Hybrid Median Filter " + this.progstr + "% Done"));
            if (this.atebit) {
                newslice8 = this.double2byte(filteredslice);
                this.ip2 = this.imp2.getProcessor();
                this.ip2.setPixels((Object)newslice8);
            } else {
                short[] newslice = this.double2short(filteredslice);
                this.ip2 = this.imp2.getProcessor();
                this.ip2.setPixels((Object)newslice);
            }
            this.stack2.addSlice(String.valueOf(i), this.ip2);
            if (this.win == null || this.win.running) continue;
            IJ.beep();
            this.quit = true;
            IJ.showMessage((String)"3d Hybrid Median Filter aborted.\nNo output will be generated.");
            return this.imp2;
        }
        this.titlestring = "3d Hybrid Median Filter - " + this.otitle;
        this.imp2.setStack(this.titlestring, this.stack2);
        return this.imp2;
    }

    private static double median(double[] array) {
        Arrays.sort(array);
        int len = array.length;
        if (len % 2 == 0) {
            return (array[len / 2 - 1] + array[len / 2]) / 2.0;
        }
        return array[(len - 1) / 2];
    }

    private short[] double2short(double[] array) {
        short[] shortarray = new short[array.length];
        for (int j = 0; j < array.length; ++j) {
            shortarray[j] = (short)array[j];
        }
        return shortarray;
    }

    private double[] short2double(short[] array) {
        double[] doublearray = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            doublearray[j] = 0xFFFF & array[j];
        }
        return doublearray;
    }

    private byte[] double2byte(double[] array) {
        byte[] bytearray = new byte[array.length];
        for (int j = 0; j < array.length; ++j) {
            bytearray[j] = (byte)array[j];
        }
        return bytearray;
    }

    private double[] byte2double(byte[] array) {
        double[] doublearray = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            doublearray[j] = 0xFF & array[j];
        }
        return doublearray;
    }
}

