/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.mask.provider;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.bean.unitvalue.extent.UnitValueExtent;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.mask.MaskFromObjects;
import org.anchoranalysis.image.core.mask.combine.MaskAnd;
import org.anchoranalysis.image.core.mask.combine.MaskOr;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.imagej.mask.ApplyImageJMorphologicalOperation;
import org.anchoranalysis.spatial.box.Extent;

public class FillHoles
extends MaskProviderUnary {
    @BeanField
    @OptionalBean
    private UnitValueExtent maxVolume = null;
    @BeanField
    private boolean skipAtBorder = true;

    public Mask createFromMask(Mask mask) throws ProvisionFailedException {
        Mask maskDuplicated = this.fillMask(mask);
        try {
            return FillHoles.fillHoles(this.filterObjectsFromMask(maskDuplicated), mask, mask.dimensions(), BinaryValuesInt.getDefault());
        }
        catch (UnitValueException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Mask fillMask(Mask mask) throws ProvisionFailedException {
        Mask maskInverted = new Mask(mask.channel(), mask.binaryValuesInt().createInverted());
        Mask maskDuplicated = mask.duplicate();
        try {
            ApplyImageJMorphologicalOperation.fill((BinaryVoxels<UnsignedByteBuffer>)maskDuplicated.binaryVoxels());
        }
        catch (OperationFailedException e1) {
            throw new ProvisionFailedException((Throwable)e1);
        }
        MaskAnd.apply((Mask)maskDuplicated, (Mask)maskInverted);
        return maskDuplicated;
    }

    private ObjectCollection filterObjectsFromMask(Mask mask) throws UnitValueException {
        ObjectsFromConnectedComponentsFactory objectCreator = new ObjectsFromConnectedComponentsFactory();
        return this.filterObjects(objectCreator.createUnsignedByte(mask.binaryVoxels()), mask.dimensions());
    }

    private ObjectCollection filterObjects(ObjectCollection objects, Dimensions dimensions) throws UnitValueException {
        double maxVolumeResolved = this.determineMaxVolume(dimensions);
        return objects.stream().filter(objectMask -> this.includeObject((ObjectMask)objectMask, dimensions.extent(), maxVolumeResolved));
    }

    private double determineMaxVolume(Dimensions dimensions) throws UnitValueException {
        if (this.maxVolume != null) {
            return this.maxVolume.resolveToVoxels(dimensions.unitConvert());
        }
        return 0.0;
    }

    private boolean includeObject(ObjectMask object, Extent extent, double maxVolumeResolved) {
        if (this.skipAtBorder && object.boundingBox().atBorderXY(extent)) {
            return false;
        }
        return this.maxVolume == null || (double)object.numberVoxelsOn() <= maxVolumeResolved;
    }

    private static Mask fillHoles(ObjectCollection filled, Mask source, Dimensions dimensions, BinaryValuesInt binaryValuesOut) {
        Mask maskFromObjects = MaskFromObjects.createFromObjects((ObjectCollection)filled, (Dimensions)dimensions, (BinaryValuesInt)binaryValuesOut);
        MaskOr.apply((Mask)maskFromObjects, (Mask)source);
        return maskFromObjects;
    }

    @Generated
    public UnitValueExtent getMaxVolume() {
        return this.maxVolume;
    }

    @Generated
    public void setMaxVolume(UnitValueExtent maxVolume) {
        this.maxVolume = maxVolume;
    }

    @Generated
    public boolean isSkipAtBorder() {
        return this.skipAtBorder;
    }

    @Generated
    public void setSkipAtBorder(boolean skipAtBorder) {
        this.skipAtBorder = skipAtBorder;
    }
}

