/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.bean.stack.provider;

import ij.ImagePlus;
import ij.plugin.MontageMaker;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.stack.StackProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.io.imagej.convert.ConvertFromImagePlus;
import org.anchoranalysis.io.imagej.convert.ConvertToImagePlus;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;

public class MontageSlices
extends StackProviderUnary {
    @BeanField
    private int columns = 0;
    @BeanField
    private double scale = 1.0;
    @BeanField
    private int sliceFirst = -1;
    @BeanField
    private int sliceLast = -1;
    @BeanField
    private int borderWidth = 0;
    @BeanField
    private boolean label = false;

    public Stack createFromStack(Stack stack) throws ProvisionFailedException {
        int numberSlices = stack.dimensions().z();
        int numberColumns = this.numberColumns(numberSlices);
        try {
            return stack.mapChannel(channel -> this.montageChannel((Channel)channel, MontageSlices.effectiveColumns(numberSlices, numberColumns), MontageSlices.rowsForColumns(numberSlices, numberColumns), this.firstSlice(), this.lastSlice(numberSlices)));
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException("Failed to execute map operation on a particular channel", (Throwable)e);
        }
    }

    private Channel montageChannel(Channel channel, int columns, int rows, int firstSlice, int lastSlice) throws OperationFailedException {
        try {
            ImagePlus imp = ConvertToImagePlus.from((Channel)channel);
            MontageMaker mm = new MontageMaker();
            ImagePlus result = mm.makeMontage2(imp, columns, rows, this.scale, firstSlice, lastSlice, 1, this.borderWidth, this.label);
            return ConvertFromImagePlus.toChannel((ImagePlus)result, (Optional)channel.dimensions().resolution());
        }
        catch (ImageJConversionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private int numberColumns(int totalNumSlices) {
        if (this.columns > 0) {
            return this.columns;
        }
        return (int)Math.ceil(Math.sqrt(totalNumSlices));
    }

    private int firstSlice() {
        if (this.sliceFirst >= 0) {
            return this.sliceFirst + 1;
        }
        return 1;
    }

    private int lastSlice(int totalNumSlices) {
        if (this.sliceLast >= 0) {
            return this.sliceLast + 1;
        }
        return totalNumSlices;
    }

    private static int effectiveColumns(int totalNumSlices, int columns) {
        return Math.min(totalNumSlices, columns);
    }

    private static int rowsForColumns(int totalNumSlices, int columns) {
        return (int)Math.ceil((double)totalNumSlices / (double)columns);
    }

    @Generated
    public int getColumns() {
        return this.columns;
    }

    @Generated
    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Generated
    public double getScale() {
        return this.scale;
    }

    @Generated
    public void setScale(double scale) {
        this.scale = scale;
    }

    @Generated
    public int getSliceFirst() {
        return this.sliceFirst;
    }

    @Generated
    public void setSliceFirst(int sliceFirst) {
        this.sliceFirst = sliceFirst;
    }

    @Generated
    public int getSliceLast() {
        return this.sliceLast;
    }

    @Generated
    public void setSliceLast(int sliceLast) {
        this.sliceLast = sliceLast;
    }

    @Generated
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Generated
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Generated
    public boolean isLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(boolean label) {
        this.label = label;
    }
}

