/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.imagej.mask;

import ij.Prefs;
import ij.plugin.filter.Binary;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.plugin.imagej.channel.provider.FilterHelper;
import org.anchoranalysis.spatial.box.Extent;

public class ApplyImageJMorphologicalOperation {
    public static void fill(BinaryVoxels<UnsignedByteBuffer> voxels) throws OperationFailedException {
        ApplyImageJMorphologicalOperation.applyOperation(voxels, "fill", 1);
    }

    public static BinaryVoxels<UnsignedByteBuffer> applyOperation(BinaryVoxels<UnsignedByteBuffer> voxels, String command, int iterations) throws OperationFailedException {
        if (!voxels.binaryValues().equals((Object)BinaryValuesInt.getDefault())) {
            throw new OperationFailedException("On byte must be 255, and off byte must be 0");
        }
        Prefs.blackBackground = true;
        Binary plugin = ApplyImageJMorphologicalOperation.createPlugin(command, voxels.extent());
        for (int i = 0; i < iterations; ++i) {
            FilterHelper.processEachSlice(voxels, arg_0 -> ((Binary)plugin).run(arg_0));
        }
        return voxels;
    }

    private static Binary createPlugin(String command, Extent extent) {
        Binary plugin = new Binary();
        plugin.setup(command, null);
        plugin.setNPasses(extent.z());
        return plugin;
    }

    @Generated
    private ApplyImageJMorphologicalOperation() {
    }
}

