/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.channel.map;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.FunctionalIterate;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.RGBChannelNames;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.channel.ChannelMapCreator;
import org.anchoranalysis.image.io.bean.channel.IndexedChannel;
import org.anchoranalysis.image.io.channel.input.ChannelMap;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;

public class Autoname
extends ChannelMapCreator {
    private static final String[] RGB_CHANNEL_NAMES = RGBChannelNames.asArray((boolean)true);

    public ChannelMap create(OpenedImageFile openedFile, Logger logger) throws CreateException {
        ChannelMap map = new ChannelMap();
        try {
            Optional names = openedFile.channelNames(logger);
            boolean rgb = openedFile.isRGB(logger) && (openedFile.numberChannels(logger) == 3 || openedFile.numberChannels(logger) == 4);
            FunctionalIterate.repeatWithIndex((int)openedFile.numberChannels(logger), channelIndex -> Autoname.addEntryToMap(map, names, rgb, channelIndex));
        }
        catch (ImageIOException e) {
            throw new CreateException((Throwable)e);
        }
        return map;
    }

    private static void addEntryToMap(ChannelMap map, Optional<List<String>> names, boolean rgb, int channelIndex) {
        String entryName = Autoname.nameFor(channelIndex, names, rgb);
        map.add(new IndexedChannel(entryName, channelIndex));
    }

    private static String nameFor(int channelIndex, Optional<List<String>> names, boolean rgb) {
        if (names.isPresent()) {
            return names.get().get(channelIndex);
        }
        if (rgb) {
            return Autoname.rgbNameFor(channelIndex);
        }
        return String.format("channel-%d", channelIndex);
    }

    private static String rgbNameFor(int channelIndex) {
        if (channelIndex < 4) {
            return RGB_CHANNEL_NAMES[channelIndex];
        }
        throw new AnchorImpossibleSituationException();
    }
}

