/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.method;

import java.nio.file.Path;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.plugin.io.bean.file.copy.method.Bytewise;
import org.anchoranalysis.plugin.io.bean.file.copy.method.CopyFilesMethod;
import org.anchoranalysis.plugin.io.bean.file.copy.method.CopyTIFFAndCompress;

public class CompressAnyTIFF
extends CopyFilesMethod {
    private Bytewise simpleCopy = new Bytewise();

    @Override
    public void makeCopyWithDirectory(Path source, Path destination) throws CreateException {
        String fileName = source.getFileName().toString().toLowerCase();
        try {
            if (ImageFileFormat.TIFF.matches(fileName)) {
                CopyTIFFAndCompress.apply(source.toString(), destination);
            } else {
                this.simpleCopy.makeCopy(source, destination);
            }
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }
}

