/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.method;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import org.anchoranalysis.core.exception.OperationFailedException;

class CopyTIFFAndCompress {
    public static void apply(String source, Path destination) throws OperationFailedException {
        try {
            Files.deleteIfExists(destination);
        }
        catch (IOException e2) {
            throw new OperationFailedException((Throwable)e2);
        }
        CopyTIFFAndCompress.compressFile(source, destination);
    }

    private static void compressFile(String source, Path destination) throws OperationFailedException {
        String d = destination.toString();
        try (TiffReader reader = CopyTIFFAndCompress.createReader(source);){
            TiffWriter writer = CopyTIFFAndCompress.createWriter(reader, d);
            int numImages = reader.getImageCount();
            for (int i = 0; i < numImages; ++i) {
                byte[] buf = reader.openBytes(i);
                writer.saveBytes(i, buf);
            }
            writer.close();
        }
        catch (IOException | DependencyException | ServiceException | FormatException e) {
            throw new OperationFailedException(e);
        }
    }

    private static TiffReader createReader(String source) throws DependencyException, ServiceException, FormatException, IOException {
        TiffReader reader = new TiffReader();
        reader.setMetadataFiltered(true);
        reader.setOriginalMetadataPopulated(true);
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        reader.setMetadataStore((MetadataStore)service.createOMEXMLMetadata());
        reader.setId(source);
        reader.setSeries(0);
        return reader;
    }

    private static TiffWriter createWriter(TiffReader reader, String destination) throws FormatException, IOException {
        TiffWriter writer = new TiffWriter();
        writer.setCompression("LZW");
        writer.setWriteSequentially(true);
        writer.setBigTiff(true);
        writer.setMetadataRetrieve((MetadataRetrieve)reader.getMetadataStore());
        writer.setId(destination);
        writer.setSeries(0);
        writer.setInterleaved(reader.isInterleaved());
        return writer;
    }

    private CopyTIFFAndCompress() {
    }
}

