/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.io.bean.file.copy.naming.cluster;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;

public class ClusterIdentifier {
    private Optional<String> name;
    private long minInstant = Long.MAX_VALUE;
    private long maxInstant = Long.MIN_VALUE;
    private LocalDateTime minDateTime;
    private LocalDateTime maxDateTime;
    private final ZoneOffset offset;

    public ClusterIdentifier(ZoneOffset offset) {
        this.name = Optional.empty();
        this.offset = offset;
    }

    public ClusterIdentifier(String name, ZoneOffset offset) {
        this.name = Optional.of(name);
        this.offset = offset;
    }

    public void addTimestamp(long timestamp) {
        if (timestamp < this.minInstant) {
            this.minInstant = timestamp;
        }
        if (timestamp > this.maxInstant) {
            this.maxInstant = timestamp;
        }
    }

    public void assignName(String name) {
        this.name = Optional.of(name);
    }

    public String name() throws OperationFailedException {
        if (this.name.isPresent()) {
            return this.name.get();
        }
        throw new OperationFailedException("No name has been assigned");
    }

    public LocalDateTime getMinTime() {
        if (this.minDateTime == null) {
            this.minDateTime = this.toDate(this.minInstant);
        }
        return this.minDateTime;
    }

    public LocalDateTime getMaxTime() {
        if (this.maxDateTime == null) {
            this.maxDateTime = this.toDate(this.maxInstant);
        }
        return this.maxDateTime;
    }

    private LocalDateTime toDate(long instant) {
        return LocalDateTime.ofEpochSecond(instant, 0, this.offset);
    }

    public long getMinInstant() {
        return this.minInstant;
    }

    public long getMaxInstant() {
        return this.maxInstant;
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }
}

